/*
 * Decompiled with CFR 0.152.
 */
package sklearn.feature_extraction.text;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import numpy.DType;
import numpy.core.Scalar;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Row;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.DOMUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;
import sklearn2pmml.feature_extraction.text.Splitter;

public class CountVectorizer
extends Transformer
implements HasNumberOfFeatures {
    private static final Joiner JOINER = Joiner.on((String)"|");
    private static final AtomicInteger SEQUENCE = new AtomicInteger(1);

    public CountVectorizer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    @Override
    public int getNumberOfFeatures() {
        return 1;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Boolean lowercase = this.getLowercase();
        Map<String, Scalar> vocabulary = this.getVocabulary();
        ClassDictUtil.checkSize(1, features);
        Feature feature = features.get(0);
        HashBiMap termIndexMap = HashBiMap.create((int)vocabulary.size());
        Set<Map.Entry<String, Scalar>> entries = vocabulary.entrySet();
        for (Map.Entry entry : entries) {
            termIndexMap.put(entry.getKey(), (Object)ValueUtil.asInt((Number)((Number)((Scalar)entry.getValue()).getOnlyElement())));
        }
        BiMap indexTermMap = termIndexMap.inverse();
        DType dType = this.getDType();
        if (lowercase.booleanValue()) {
            FieldName name = FeatureUtil.createName((String)"lowercase", (Feature)feature);
            DerivedField derivedField = encoder.getDerivedField(name);
            if (derivedField == null) {
                Apply apply = PMMLUtil.createApply((String)"lowercase", (Expression[])new Expression[]{feature.ref()});
                derivedField = encoder.createDerivedField(name, OpType.CATEGORICAL, DataType.STRING, (Expression)apply);
            }
            feature = new Feature((PMMLEncoder)encoder, derivedField.getName(), derivedField.getDataType()){

                public ContinuousFeature toContinuousFeature() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        DefineFunction defineFunction = this.encodeDefineFunction();
        encoder.addDefineFunction(defineFunction);
        ArrayList<Feature> result = new ArrayList<Feature>();
        int max = indexTermMap.size();
        for (int i = 0; i < max; ++i) {
            String term = (String)indexTermMap.get((Object)i);
            final Apply apply = this.encodeApply(defineFunction.getName(), feature, i, term);
            Feature termFeature = new Feature((PMMLEncoder)encoder, FieldName.create((String)(defineFunction.getName() + "(" + term + ")")), dType != null ? dType.getDataType() : DataType.DOUBLE){

                public ContinuousFeature toContinuousFeature() {
                    PMMLEncoder encoder = this.ensureEncoder();
                    DerivedField derivedField = encoder.getDerivedField(this.getName());
                    if (derivedField == null) {
                        derivedField = encoder.createDerivedField(this.getName(), OpType.CONTINUOUS, this.getDataType(), (Expression)apply);
                    }
                    return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
                }
            };
            result.add(termFeature);
        }
        return result;
    }

    public DefineFunction encodeDefineFunction() {
        String analyzer = this.getAnalyzer();
        List<String> stopWords = this.getStopWords();
        Object[] nGramRange = this.getNGramRange();
        Boolean binary = this.getBinary();
        Object preprocessor = this.getPreprocessor();
        String stripAccents = this.getStripAccents();
        Splitter tokenizer = this.getTokenizer();
        switch (analyzer) {
            case "word": {
                break;
            }
            default: {
                throw new IllegalArgumentException(analyzer);
            }
        }
        if (preprocessor != null) {
            throw new IllegalArgumentException();
        }
        if (stripAccents != null) {
            throw new IllegalArgumentException(stripAccents);
        }
        ParameterField documentField = new ParameterField(FieldName.create((String)"document"));
        ParameterField termField = new ParameterField(FieldName.create((String)"term"));
        TextIndex textIndex = new TextIndex(documentField.getName()).setTokenize(Boolean.TRUE).setWordSeparatorCharacterRE(tokenizer.getSeparatorRE()).setLocalTermWeights((TextIndex.LocalTermWeights)(binary != false ? TextIndex.LocalTermWeights.BINARY : null)).setExpression((Expression)new FieldRef(termField.getName()));
        if (stopWords != null && stopWords.size() > 0 && !Arrays.equals(nGramRange, (Object[])new Integer[]{1, 1})) {
            DocumentBuilder documentBuilder = DOMUtil.createDocumentBuilder();
            InlineTable inlineTable = new InlineTable().addRows(new Row[]{DOMUtil.createRow((DocumentBuilder)documentBuilder, Arrays.asList("string", "stem", "regex"), Arrays.asList("(^|\\s+)\\p{Punct}*(" + JOINER.join(stopWords) + ")\\p{Punct}*(\\s+|$)", " ", "true"))});
            TextIndexNormalization textIndexNormalization = new TextIndexNormalization().setRecursive(Boolean.TRUE).setInlineTable(inlineTable);
            textIndex.addTextIndexNormalizations(new TextIndexNormalization[]{textIndexNormalization});
        }
        String name = this.functionName() + "@" + String.valueOf(SEQUENCE.getAndIncrement());
        DefineFunction defineFunction = new DefineFunction(name, OpType.CONTINUOUS, null).setDataType(DataType.DOUBLE).addParameterFields(new ParameterField[]{documentField, termField}).setExpression((Expression)textIndex);
        return defineFunction;
    }

    public Apply encodeApply(String function, Feature feature, int index, String term) {
        Constant constant = PMMLUtil.createConstant((Object)term).setDataType(DataType.STRING);
        return PMMLUtil.createApply((String)function, (Expression[])new Expression[]{feature.ref(), constant});
    }

    public String functionName() {
        return "tf";
    }

    public String getAnalyzer() {
        return (String)this.get("analyzer");
    }

    public Boolean getBinary() {
        return (Boolean)this.get("binary");
    }

    public Boolean getLowercase() {
        return (Boolean)this.get("lowercase");
    }

    public Object[] getNGramRange() {
        return (Object[])this.get("ngram_range");
    }

    public Object getPreprocessor() {
        return this.get("preprocessor");
    }

    public List<String> getStopWords() {
        Object stopWords = this.get("stop_words");
        if (stopWords instanceof String) {
            return CountVectorizer.loadStopWords((String)stopWords);
        }
        return (List)stopWords;
    }

    public String getStripAccents() {
        return (String)this.get("strip_accents");
    }

    public Splitter getTokenizer() {
        Object tokenizer = this.get("tokenizer");
        try {
            if (tokenizer == null) {
                throw new NullPointerException();
            }
            return (Splitter)((Object)tokenizer);
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("The tokenizer object (" + ClassDictUtil.formatClass(tokenizer) + ") is not Splitter");
        }
    }

    public String getTokenPattern() {
        return (String)this.get("token_pattern");
    }

    public Map<String, Scalar> getVocabulary() {
        return (Map)this.get("vocabulary_");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> loadStopWords(String stopWords) {
        InputStream is = CountVectorizer.class.getResourceAsStream("/stop_words/" + stopWords + ".txt");
        if (is == null) {
            throw new IllegalArgumentException(stopWords);
        }
        try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
            List list = CharStreams.readLines((Readable)reader);
            return list;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(stopWords, ioe);
        }
    }
}

