/*
 * Decompiled with CFR 0.152.
 */
package joblib;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import org.jpmml.sklearn.HasArray;

public abstract class NDArrayWrapper
extends ClassDict
implements HasArray {
    private NDArray content = null;

    public NDArrayWrapper(String module, String name) {
        super(module, name);
    }

    public abstract InputStream getInputStream() throws IOException;

    @Override
    public List<?> getArrayContent() {
        NDArray content = this.getContent();
        return content.getArrayContent();
    }

    @Override
    public int[] getArrayShape() {
        NDArray content = this.getContent();
        return content.getArrayShape();
    }

    public String getFileName() {
        return (String)this.get("filename");
    }

    public NDArray getContent() {
        if (this.content == null) {
            this.content = this.loadContent();
        }
        return this.content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NDArray loadContent() {
        try (InputStream is = this.getInputStream();){
            NDArray nDArray = NDArrayUtil.parseNpy(is);
            return nDArray;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

