/*
 * Decompiled with CFR 0.152.
 */
package lightgbm.sklearn;

import lightgbm.sklearn.Booster;
import lightgbm.sklearn.HasBooster;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static int getNumberOfFeatures(HasBooster hasBooster) {
        GBDT gbdt = BoosterUtil.getGBDT(hasBooster);
        String[] featureNames = gbdt.getFeatureNames();
        return featureNames.length;
    }

    public static MiningModel encodeModel(HasBooster hasBooster, Schema schema) {
        GBDT gbdt = BoosterUtil.getGBDT(hasBooster);
        Schema lgbmSchema = LightGBMUtil.toLightGBMSchema((GBDT)gbdt, (Schema)schema);
        MiningModel miningModel = gbdt.encodeMiningModel(lgbmSchema);
        return miningModel;
    }

    private static GBDT getGBDT(HasBooster hasBooster) {
        Booster booster = hasBooster.getBooster();
        return booster.getGBDT();
    }
}

