/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import joblib.NDArrayWrapper;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import org.jpmml.sklearn.HasArray;

public class ClassDictUtil {
    private ClassDictUtil() {
    }

    public static List<?> getArray(ClassDict dict, String name) {
        Object object = dict.get((Object)name);
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayContent();
        }
        if (object instanceof Number) {
            return Collections.singletonList(object);
        }
        throw new IllegalArgumentException("The value of the " + ClassDictUtil.formatMember(dict, name) + " attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public static List<?> getArray(ClassDict dict, String name, String key) {
        Object object = dict.get((Object)name);
        if (object instanceof NDArrayWrapper) {
            NDArrayWrapper arrayWrapper = (NDArrayWrapper)object;
            object = arrayWrapper.getContent();
        }
        if (object instanceof NDArray) {
            NDArray array = (NDArray)object;
            return NDArrayUtil.getContent(array, key);
        }
        throw new IllegalArgumentException("The value of the " + ClassDictUtil.formatMember(dict, name) + " attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public static int[] getShape(ClassDict dict, String name, int length) {
        int[] shape = ClassDictUtil.getShape(dict, name);
        if (shape.length != length) {
            throw new IllegalArgumentException("The dimensionality of the " + ClassDictUtil.formatMember(dict, name) + " attribute (" + shape.length + ") is not " + length);
        }
        return shape;
    }

    public static int[] getShape(ClassDict dict, String name) {
        Object object = dict.get((Object)name);
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayShape();
        }
        if (object instanceof Number) {
            return new int[]{1};
        }
        throw new IllegalArgumentException("The value of the " + ClassDictUtil.formatMember(dict, name) + " attribute (" + ClassDictUtil.formatClass(object) + ") is not a supported array type");
    }

    public static void checkSize(Collection<?> ... collections) {
        Collection<?> prevCollection = null;
        for (Collection<?> collection : collections) {
            if (collection == null) continue;
            if (prevCollection != null && collection.size() != prevCollection.size()) {
                throw new IllegalArgumentException("Expected the same number of elements, got different numbers of elements");
            }
            prevCollection = collection;
        }
    }

    public static void checkSize(int size, Collection<?> ... collections) {
        for (Collection<?> collection : collections) {
            if (collection == null || collection.size() == size) continue;
            throw new IllegalArgumentException("Expected " + size + " element(s), got " + collection.size() + " element(s)");
        }
    }

    public static String formatMember(ClassDict dict, String name) {
        String clazz = (String)dict.get((Object)"__class__");
        return clazz + "." + name;
    }

    public static String formatClass(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ClassDict) {
            ClassDict dict = (ClassDict)object;
            String clazz = (String)dict.get((Object)"__class__");
            return "Python class " + clazz;
        }
        Class<?> clazz = object.getClass();
        return "Java class " + clazz.getName();
    }

    public static String toString(ClassDict dict) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n{\n");
        String sep = "";
        ArrayList entries = new ArrayList(dict.entrySet());
        Comparator comparator = new Comparator<Map.Entry<String, ?>>(){

            @Override
            public int compare(Map.Entry<String, ?> left, Map.Entry<String, ?> right) {
                return left.getKey().compareToIgnoreCase(right.getKey());
            }
        };
        Collections.sort(entries, comparator);
        for (Map.Entry entry : entries) {
            sb.append(sep);
            sep = "\n";
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            sb.append("\t" + key + "=" + value + " // " + (value != null ? value.getClass().getName() : "N/A"));
        }
        sb.append("\n}\n");
        return sb.toString();
    }
}

