/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.Feature;
import org.jpmml.sklearn.ExpressionTranslatorConstants;
import org.jpmml.sklearn.ExpressionTranslatorTokenManager;
import org.jpmml.sklearn.ParseException;
import org.jpmml.sklearn.Provider;
import org.jpmml.sklearn.SimpleCharStream;
import org.jpmml.sklearn.StringProvider;
import org.jpmml.sklearn.Token;
import org.jpmml.sklearn.TokenMgrException;

public class ExpressionTranslator
implements ExpressionTranslatorConstants {
    private List<Feature> features = null;
    public ExpressionTranslatorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[8];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public List<Feature> getFeatures() {
        return this.features;
    }

    private void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public static Expression translate(String string, List<Feature> features) {
        Expression expression;
        try {
            ExpressionTranslator expressionTranslator = new ExpressionTranslator(string);
            expressionTranslator.setFeatures(features);
            expression = expressionTranslator.translateExpressionInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(string, pe);
        }
        return expression;
    }

    private static Apply createApply(String function, Expression ... expressions) {
        Apply apply = new Apply(function);
        for (Expression expression : expressions) {
            apply.addExpressions(new Expression[]{expression});
        }
        return apply;
    }

    private static String translateValue(Token value) {
        String image = value.image;
        switch (value.kind) {
            case 13: {
                if (!image.endsWith("l") && !image.endsWith("L")) break;
                image = image.substring(0, image.length() - 1);
                break;
            }
        }
        return image;
    }

    private final Expression translateExpressionInternal() throws ParseException {
        Expression expression = this.Expression();
        this.jj_consume_token(0);
        return expression;
    }

    public final Expression Expression() throws ParseException {
        Expression expression = this.AdditiveExpression();
        return expression;
    }

    public final Expression AdditiveExpression() throws ParseException {
        Expression left = this.MultiplicativeExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: {
                    operator = this.jj_consume_token(9);
                    break;
                }
                case 10: {
                    operator = this.jj_consume_token(10);
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.MultiplicativeExpression();
            left = ExpressionTranslator.createApply(operator.image, left, right);
        }
        return left;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression left = this.UnaryExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    operator = this.jj_consume_token(3);
                    break;
                }
                case 4: {
                    operator = this.jj_consume_token(4);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.UnaryExpression();
            left = ExpressionTranslator.createApply(operator.image, left, right);
        }
        return left;
    }

    public final Expression UnaryExpression() throws ParseException {
        Token sign = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: {
                        sign = this.jj_consume_token(9);
                        break block0;
                    }
                    case 10: {
                        sign = this.jj_consume_token(10);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        Expression expression = this.PrimaryExpression();
        if (sign != null && sign.kind == 10) {
            if (expression instanceof Constant) {
                Constant constant = (Constant)expression;
                constant.setValue("-" + constant.getValue());
            } else {
                Constant constant = new Constant().setValue("-1");
                expression = ExpressionTranslator.createApply("*", new Expression[]{constant, expression});
            }
        }
        return expression;
    }

    public final Expression PrimaryExpression() throws ParseException {
        Expression expression;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                expression = this.ParenthesizedExpression();
                break;
            }
            case 15: {
                expression = this.FeatureInvocationExpression();
                break;
            }
            case 13: 
            case 14: {
                expression = this.LiteralExpression();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expression;
    }

    public final Expression ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(5);
        Expression expression = this.Expression();
        this.jj_consume_token(6);
        return expression;
    }

    public final FieldRef FeatureInvocationExpression() throws ParseException {
        Token variable = this.jj_consume_token(15);
        this.jj_consume_token(7);
        this.jj_consume_token(12);
        this.jj_consume_token(11);
        Token column = this.jj_consume_token(13);
        this.jj_consume_token(8);
        List<Feature> features = this.getFeatures();
        if (!"X".equals(variable.image)) {
            throw new IllegalArgumentException(variable.image);
        }
        int index = Integer.parseInt(column.image);
        if (index < 0 || index >= features.size()) {
            throw new IllegalArgumentException(this.token.image);
        }
        Feature feature = features.get(index);
        return feature.ref();
    }

    public final Constant LiteralExpression() throws ParseException {
        DataType dataType;
        Token value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: {
                value = this.jj_consume_token(13);
                dataType = DataType.INTEGER;
                break;
            }
            case 14: {
                value = this.jj_consume_token(14);
                dataType = DataType.DOUBLE;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Constant constant = new Constant().setValue(ExpressionTranslator.translateValue(value)).setDataType(dataType);
        return constant;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1536, 1536, 24, 24, 1536, 1536, 57376, 24576};
    }

    public ExpressionTranslator(Provider stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ExpressionTranslatorTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 8; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[20];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 8; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 20; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ExpressionTranslator.jj_la1_init_0();
    }
}

