/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import joblib.NDArrayWrapperConstructor;
import joblib.NumpyArrayWrapper;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.Unpickler;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArray;
import org.jpmml.sklearn.CClassDict;
import org.jpmml.sklearn.CompressedInputStreamStorage;
import org.jpmml.sklearn.ExtensionObjectConstructor;
import org.jpmml.sklearn.FileStorage;
import org.jpmml.sklearn.ObjectConstructor;
import org.jpmml.sklearn.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickleUtil {
    private static final Logger logger = LoggerFactory.getLogger(PickleUtil.class);

    private PickleUtil() {
    }

    public static Storage createStorage(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                return new CompressedInputStreamStorage(is);
            }
            catch (IOException ioe) {
                ((InputStream)is).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new FileStorage(file);
    }

    public static Object unpickle(Storage storage) throws IOException {
        ObjectConstructor[] constructors;
        for (ObjectConstructor constructor : constructors = new ObjectConstructor[]{new NDArrayWrapperConstructor("joblib.numpy_pickle", "NDArrayWrapper", storage), new NDArrayWrapperConstructor("sklearn.externals.joblib.numpy_pickle", "NDArrayWrapper", storage)}) {
            Unpickler.registerConstructor((String)constructor.getModule(), (String)constructor.getName(), (IObjectConstructor)constructor);
        }
        try (final InputStream is = storage.getObject();){
            Unpickler unpickler = new Unpickler(){

                protected Object dispatch(short key) throws IOException {
                    Object head;
                    Object result = super.dispatch(key);
                    if (key == 98 && (head = this.stack.peek()) instanceof NumpyArrayWrapper) {
                        NumpyArrayWrapper arrayWrapper = (NumpyArrayWrapper)((Object)head);
                        this.stack.pop();
                        NDArray array = arrayWrapper.toArray(is);
                        this.stack.add((Object)array);
                    }
                    return result;
                }
            };
            Object object = unpickler.load(is);
            return object;
        }
    }

    private static void init() {
        Enumeration<URL> urls;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            urls = classLoader.getResources("META-INF/sklearn2pmml.properties");
        }
        catch (IOException ioe) {
            logger.warn("Failed to find resources", (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            logger.debug("Loading resource {}", (Object)url);
            try {
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    Properties properties = new Properties();
                    properties.load(is);
                    PickleUtil.init(classLoader, properties);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException ioe) {
                logger.warn("Failed to load resource", (Throwable)ioe);
            }
        }
    }

    private static void init(ClassLoader classLoader, Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            ObjectConstructor constructor;
            Class<?> clazz;
            String value = properties.getProperty(key);
            if (value == null || "".equals(value)) {
                value = key;
            }
            logger.debug("Mapping Python class {} to Java class {}", (Object)key, (Object)value);
            int dot = key.lastIndexOf(46);
            if (dot < 0) {
                logger.warn("Failed to identify the module and name parts of Python class {}", (Object)key);
                continue;
            }
            String module = key.substring(0, dot);
            String name = key.substring(dot + 1);
            try {
                clazz = classLoader.loadClass(value);
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn("Failed to load Java class {}", (Object)value);
                continue;
            }
            if (CClassDict.class.isAssignableFrom(clazz)) {
                constructor = new ExtensionObjectConstructor(module, name, (Class<? extends CClassDict>)clazz);
            } else if (ClassDict.class.isAssignableFrom(clazz)) {
                constructor = new ObjectConstructor(module, name, clazz);
            } else {
                logger.warn("Failed to identify the type of Java class {}", (Object)value);
                continue;
            }
            Unpickler.registerConstructor((String)constructor.getModule(), (String)constructor.getName(), (IObjectConstructor)constructor);
        }
    }

    static {
        PickleUtil.init();
    }
}

