/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.TreeModelProducer;
import org.jpmml.sklearn.visitors.TreeModelCompactor;
import sklearn.BaseEstimator;
import sklearn.HasNumberOfFeatures;

public abstract class Estimator
extends BaseEstimator
implements HasNumberOfFeatures {
    public Estimator(String module, String name) {
        super(module, name);
    }

    public abstract MiningFunction getMiningFunction();

    public abstract boolean isSupervised();

    public abstract Model encodeModel(Schema var1);

    public Model encodeModel(Schema schema, SkLearnEncoder encoder) {
        Boolean compact;
        Model model = this.encodeModel(schema);
        if (this instanceof TreeModelProducer && (compact = (Boolean)this.getOption("compact", Boolean.FALSE)).booleanValue()) {
            TreeModelCompactor visitor = new TreeModelCompactor();
            visitor.applyTo((Visitable)model);
        }
        return model;
    }

    @Override
    public int getNumberOfFeatures() {
        return ValueUtil.asInt((Number)((Number)this.get("n_features_")));
    }

    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    public DataType getDataType() {
        return DataType.DOUBLE;
    }
}

