/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Selector;
import sklearn.Transformer;
import sklearn.pipeline.FeatureUnion;
import sklearn.pipeline.Pipeline;

public class TransformerUtil {
    private static final Function<Object, Transformer> transformerFunction = new Function<Object, Transformer>(){

        public Transformer apply(Object object) {
            try {
                if (object == null) {
                    throw new NullPointerException();
                }
                return (Transformer)((Object)object);
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException("The transformer object (" + ClassDictUtil.formatClass(object) + ") is not a Transformer or is not a supported Transformer subclass", re);
            }
        }
    };
    private static final Function<Object, Selector> selectorFunction = new Function<Object, Selector>(){

        public Selector apply(Object object) {
            try {
                if (object == null) {
                    throw new NullPointerException();
                }
                return (Selector)object;
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException("The transformer object (" + ClassDictUtil.formatClass(object) + ") is not a Selector or is not a supported Selector subclass");
            }
        }
    };

    private TransformerUtil() {
    }

    public static Transformer asTransformer(Object object) {
        return (Transformer)((Object)transformerFunction.apply(object));
    }

    public static List<Transformer> asTransformerList(List<?> objects) {
        return Lists.transform(objects, transformerFunction);
    }

    public static Selector asSelector(Object object) {
        return (Selector)selectorFunction.apply(object);
    }

    public static List<Selector> asSelectorList(List<?> objects) {
        return Lists.transform(objects, selectorFunction);
    }

    public static Transformer getHead(List<Transformer> transformers) {
        while (transformers.size() > 0) {
            Transformer transformer = transformers.get(0);
            if (transformer instanceof FeatureUnion) {
                FeatureUnion featureUnion = (FeatureUnion)transformer;
                transformers = featureUnion.getTransformers();
                continue;
            }
            if (transformer instanceof Pipeline) {
                Pipeline pipeline = (Pipeline)transformer;
                transformers = pipeline.getTransformers();
                continue;
            }
            return transformer;
        }
        return null;
    }
}

