/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.voting_classifier;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Classifier;
import sklearn.Estimator;
import sklearn.EstimatorUtil;

public class VotingClassifier
extends Classifier {
    public VotingClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<? extends Classifier> estimators = this.getEstimators();
        Estimator estimator = estimators.get(0);
        return estimator.getNumberOfFeatures();
    }

    @Override
    public Model encodeModel(Schema schema) {
        List<? extends Classifier> estimators = this.getEstimators();
        List<? extends Number> weights = this.getWeights();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        ArrayList<Model> models = new ArrayList<Model>();
        for (Classifier classifier : estimators) {
            Model model = classifier.encodeModel(schema);
            models.add(model);
        }
        String voting = this.getVoting();
        Segmentation.MultipleModelMethod multipleModelMethod = VotingClassifier.parseVoting(voting, weights != null && weights.size() > 0);
        MiningModel miningModel = new MiningModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)multipleModelMethod, models, weights)).setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (CategoricalLabel)categoricalLabel));
        return miningModel;
    }

    public List<? extends Classifier> getEstimators() {
        List estimators = (List)this.get("estimators_");
        return EstimatorUtil.asClassifierList(estimators);
    }

    public String getVoting() {
        return (String)this.get("voting");
    }

    public List<? extends Number> getWeights() {
        Object weights = this.get("weights");
        if (weights == null || weights instanceof List) {
            return (List)weights;
        }
        return ClassDictUtil.getArray(this, "weights");
    }

    private static Segmentation.MultipleModelMethod parseVoting(String voting, boolean weighted) {
        switch (voting) {
            case "hard": {
                return weighted ? Segmentation.MultipleModelMethod.WEIGHTED_MAJORITY_VOTE : Segmentation.MultipleModelMethod.MAJORITY_VOTE;
            }
            case "soft": {
                return weighted ? Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE : Segmentation.MultipleModelMethod.AVERAGE;
            }
        }
        throw new IllegalArgumentException(voting);
    }
}

