/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DiscrStats;
import org.dmg.pmml.OpType;
import org.dmg.pmml.UnivariateStats;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.TypeUtil;
import sklearn2pmml.decoration.Domain;

public class CategoricalDomain
extends Domain {
    public CategoricalDomain(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        Boolean withData = this.getWithData();
        if (withData.booleanValue()) {
            List<?> data = this.getData();
            return TypeUtil.getDataType(data, DataType.STRING);
        }
        return DataType.STRING;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Boolean withData = this.getWithData();
        Boolean withStatistics = this.getWithStatistics();
        ClassDictUtil.checkSize(1, features);
        Feature feature = features.get(0);
        WildcardFeature wildcardFeature = (WildcardFeature)feature;
        if (withData.booleanValue()) {
            List<?> data = this.getData();
            Function<Object, String> function = new Function<Object, String>(){

                public String apply(Object object) {
                    return ValueUtil.formatValue((Object)object);
                }
            };
            List categories = Lists.transform(data, (Function)function);
            feature = wildcardFeature.toCategoricalFeature(categories);
        }
        if (withStatistics.booleanValue()) {
            Map<String, ?> counts = CategoricalDomain.extractMap(this.getCounts(), 0);
            Object[] discrStats = this.getDiscrStats();
            UnivariateStats univariateStats = new UnivariateStats().setField(wildcardFeature.getName()).setCounts(CategoricalDomain.createCounts(counts)).setDiscrStats(CategoricalDomain.createDiscrStats(discrStats));
            encoder.putUnivariateStats(univariateStats);
        }
        return super.encodeFeatures(Collections.singletonList(feature), encoder);
    }

    public List<?> getData() {
        return ClassDictUtil.getArray(this, "data_");
    }

    public Object[] getDiscrStats() {
        return (Object[])this.get("discr_stats_");
    }

    public static DiscrStats createDiscrStats(Object[] objects) {
        List<?> values = CategoricalDomain.asArray(objects[0]);
        List counts = ValueUtil.asIntegers(CategoricalDomain.asArray(objects[1]));
        ClassDictUtil.checkSize(values, counts);
        DiscrStats discrStats = new DiscrStats().addArrays(new Array[]{PMMLUtil.createStringArray(values), PMMLUtil.createIntArray((List)counts)});
        return discrStats;
    }
}

