/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn.visitors;

import java.util.Deque;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.visitors.AbstractVisitor;

public class TreeModelCompactor
extends AbstractVisitor {
    private MiningFunction miningFunction = null;

    public void pushParent(PMMLObject object) {
        super.pushParent(object);
        if (object instanceof Node) {
            this.handleNodePush((Node)object);
        } else if (object instanceof TreeModel) {
            this.handleTreeModelPush((TreeModel)object);
        }
    }

    public PMMLObject popParent() {
        PMMLObject object = super.popParent();
        if (object instanceof Node) {
            this.handleNodePop((Node)object);
        } else if (object instanceof TreeModel) {
            this.handleTreeModelPop((TreeModel)object);
        }
        return object;
    }

    public VisitorAction visit(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        TreeModel.SplitCharacteristic splitCharacteristic = treeModel.getSplitCharacteristic();
        if (!(TreeModel.MissingValueStrategy.NONE.equals((Object)missingValueStrategy) && TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION.equals((Object)noTrueChildStrategy) && TreeModel.SplitCharacteristic.BINARY_SPLIT.equals((Object)splitCharacteristic))) {
            throw new IllegalArgumentException();
        }
        treeModel.setMissingValueStrategy(TreeModel.MissingValueStrategy.NULL_PREDICTION).setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        MiningFunction miningFunction = treeModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                treeModel.setNoTrueChildStrategy(TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION);
                break;
            }
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return super.visit(treeModel);
    }

    private void handleNodePush(Node node) {
        String id = node.getId();
        String score = node.getScore();
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (children.size() != 2 || score != null) {
                throw new IllegalArgumentException();
            }
            Node firstChild = (Node)children.get(0);
            Node secondChild = (Node)children.get(1);
            SimplePredicate firstPredicate = (SimplePredicate)firstChild.getPredicate();
            SimplePredicate secondPredicate = (SimplePredicate)secondChild.getPredicate();
            if (!firstPredicate.getField().equals((Object)secondPredicate.getField())) {
                throw new IllegalArgumentException();
            }
            if (SimplePredicate.Operator.NOT_EQUAL.equals((Object)firstPredicate.getOperator()) && SimplePredicate.Operator.EQUAL.equals((Object)secondPredicate.getOperator())) {
                children.remove(0);
                children.add(1, firstChild);
                firstChild = (Node)children.get(0);
                secondChild = (Node)children.get(1);
            } else if (!SimplePredicate.Operator.LESS_OR_EQUAL.equals((Object)firstPredicate.getOperator()) || !SimplePredicate.Operator.GREATER_THAN.equals((Object)secondPredicate.getOperator())) {
                throw new IllegalArgumentException();
            }
            secondChild.setPredicate((Predicate)new True());
        } else if (score == null) {
            throw new IllegalArgumentException();
        }
        node.setId(null);
    }

    private void handleNodePop(Node node) {
        String score = node.getScore();
        Predicate predicate = node.getPredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            String parentScore = parentNode.getScore();
            if (parentScore != null) {
                throw new IllegalArgumentException();
            }
            if (MiningFunction.REGRESSION.equals((Object)this.miningFunction)) {
                parentNode.setScore(score);
                List parentChildren = parentNode.getNodes();
                boolean success = parentChildren.remove(node);
                if (!success) {
                    throw new IllegalArgumentException();
                }
                if (node.hasNodes()) {
                    List children = node.getNodes();
                    parentChildren.addAll(children);
                }
            } else if (MiningFunction.CLASSIFICATION.equals((Object)this.miningFunction)) {
                if (node.hasNodes()) {
                    List parentChildren = parentNode.getNodes();
                    boolean success = parentChildren.remove(node);
                    if (!success) {
                        throw new IllegalArgumentException();
                    }
                    List children = node.getNodes();
                    parentChildren.addAll(children);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private void handleTreeModelPush(TreeModel treeModel) {
        this.miningFunction = treeModel.getMiningFunction();
    }

    private void handleTreeModelPop(TreeModel treeModel) {
        this.miningFunction = null;
    }

    private Node getParentNode() {
        Deque parents = this.getParents();
        PMMLObject parent = (PMMLObject)parents.peekFirst();
        if (parent instanceof Node) {
            return (Node)parent;
        }
        return null;
    }
}

