/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.jpmml.converter.Feature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;
import sklearn.preprocessing.ImputerUtil;

public class Imputer
extends Transformer
implements HasNumberOfFeatures {
    public Imputer(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getStatisticsShape();
        return shape[0];
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Object missingValues = this.getMissingValues();
        List<? extends Number> statistics = this.getStatistics();
        String strategy = this.getStrategy();
        ClassDictUtil.checkSize(features, statistics);
        if ("NaN".equals(missingValues)) {
            missingValues = null;
        }
        MissingValueTreatmentMethod missingValueTreatment = Imputer.parseStrategy(strategy);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Number statistic = statistics.get(i);
            result.add(ImputerUtil.encodeFeature(feature, (Number)missingValues, statistic, missingValueTreatment, encoder));
        }
        return result;
    }

    public Object getMissingValues() {
        return this.get("missing_values");
    }

    public List<? extends Number> getStatistics() {
        return ClassDictUtil.getArray(this, "statistics_");
    }

    public String getStrategy() {
        return (String)this.get("strategy");
    }

    private int[] getStatisticsShape() {
        return ClassDictUtil.getShape(this, "statistics_", 1);
    }

    private static MissingValueTreatmentMethod parseStrategy(String strategy) {
        switch (strategy) {
            case "mean": {
                return MissingValueTreatmentMethod.AS_MEAN;
            }
            case "median": {
                return MissingValueTreatmentMethod.AS_MEDIAN;
            }
            case "most_frequent": {
                return MissingValueTreatmentMethod.AS_MODE;
            }
        }
        throw new IllegalArgumentException(strategy);
    }
}

