/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import com.google.common.collect.Iterables;
import java.util.List;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.jpmml.converter.CMatrix;
import org.jpmml.converter.Matrix;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.support_vector_machine.LibSVMUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Regressor;
import sklearn.svm.SupportVectorMachineUtil;

public abstract class BaseLibSVMRegressor
extends Regressor {
    public BaseLibSVMRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getSupportVectorsShape();
        return shape[1];
    }

    public SupportVectorMachineModel encodeModel(Schema schema) {
        int[] shape = this.getSupportVectorsShape();
        int numberOfVectors = shape[0];
        int numberOfFeatures = shape[1];
        List<Integer> support = this.getSupport();
        List<? extends Number> supportVectors = this.getSupportVectors();
        List<? extends Number> dualCoef = this.getDualCoef();
        List<? extends Number> intercept = this.getIntercept();
        SupportVectorMachineModel supportVectorMachineModel = LibSVMUtil.createRegression((Matrix)new CMatrix(ValueUtil.asDoubles(supportVectors), numberOfVectors, numberOfFeatures), SupportVectorMachineUtil.formatIds(support), (Double)ValueUtil.asDouble((Number)((Number)Iterables.getOnlyElement(intercept))), (List)ValueUtil.asDoubles(dualCoef), (Schema)schema).setKernel(SupportVectorMachineUtil.createKernel(this.getKernel(), this.getDegree(), this.getGamma(), this.getCoef0()));
        return supportVectorMachineModel;
    }

    public String getKernel() {
        return (String)this.get("kernel");
    }

    public Integer getDegree() {
        return ValueUtil.asInteger((Number)((Number)this.get("degree")));
    }

    public Double getGamma() {
        return ValueUtil.asDouble((Number)((Number)this.get("_gamma")));
    }

    public Double getCoef0() {
        return ValueUtil.asDouble((Number)((Number)this.get("coef0")));
    }

    public List<Integer> getSupport() {
        return ValueUtil.asIntegers(ClassDictUtil.getArray(this, "support_"));
    }

    public List<? extends Number> getSupportVectors() {
        return ClassDictUtil.getArray(this, "support_vectors_");
    }

    public List<? extends Number> getDualCoef() {
        return ClassDictUtil.getArray(this, "_dual_coef_");
    }

    public List<? extends Number> getIntercept() {
        return ClassDictUtil.getArray(this, "_intercept_");
    }

    private int[] getSupportVectorsShape() {
        return ClassDictUtil.getShape(this, "support_vectors_", 2);
    }
}

