/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Counts;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn2pmml.decoration.DomainUtil;

public abstract class Domain
extends Transformer {
    public Domain(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        MissingValueTreatmentMethod missingValueTreatment = DomainUtil.parseMissingValueTreatment(this.getMissingValueTreatment());
        Object missingValueReplacement = this.getMissingValueReplacement();
        if (missingValueReplacement != null && missingValueTreatment == null) {
            missingValueTreatment = MissingValueTreatmentMethod.AS_VALUE;
        }
        InvalidValueTreatmentMethod invalidValueTreatment = DomainUtil.parseInvalidValueTreatment(this.getInvalidValueTreatment());
        final Object invalidValueReplacement = this.getInvalidValueReplacement();
        if (invalidValueReplacement != null && invalidValueTreatment == null) {
            invalidValueTreatment = InvalidValueTreatmentMethod.AS_IS;
        }
        for (Feature feature : features) {
            FieldName name = feature.getName();
            if (missingValueTreatment != null) {
                MissingValueDecorator missingValueDecorator = new MissingValueDecorator().setMissingValueTreatment(missingValueTreatment).setMissingValueReplacement(missingValueReplacement != null ? ValueUtil.formatValue((Object)missingValueReplacement) : null);
                encoder.addDecorator(name, (Decorator)missingValueDecorator);
            }
            if (invalidValueTreatment == null) continue;
            InvalidValueDecorator invalidValueDecorator = new InvalidValueDecorator(){

                public void decorate(DataField dataField, MiningField miningField) {
                    super.decorate(dataField, miningField);
                    if (invalidValueReplacement != null) {
                        miningField.setInvalidValueReplacement(ValueUtil.formatValue((Object)invalidValueReplacement));
                    }
                }
            }.setInvalidValueTreatment(invalidValueTreatment);
            encoder.addDecorator(name, (Decorator)invalidValueDecorator);
        }
        return features;
    }

    public String getMissingValueTreatment() {
        return (String)this.get("missing_value_treatment");
    }

    public Object getMissingValueReplacement() {
        return this.get("missing_value_replacement");
    }

    public String getInvalidValueTreatment() {
        return (String)this.get("invalid_value_treatment");
    }

    public Object getInvalidValueReplacement() {
        return this.get("invalid_value_replacement");
    }

    public Boolean getWithData() {
        Boolean withData = (Boolean)this.get("with_data");
        if (withData == null) {
            return Boolean.TRUE;
        }
        return withData;
    }

    public Boolean getWithStatistics() {
        Boolean withStatistics = (Boolean)this.get("with_statistics");
        if (withStatistics == null) {
            return Boolean.FALSE;
        }
        return withStatistics;
    }

    public Map<String, ?> getCounts() {
        return (Map)this.get("counts_");
    }

    public static Counts createCounts(Map<String, ?> values) {
        Counts counts = new Counts().setTotalFreq(Domain.selectValue(values, "totalFreq", 0.0).doubleValue()).setMissingFreq(Domain.selectValue(values, "missingFreq")).setInvalidFreq(Domain.selectValue(values, "invalidFreq"));
        return counts;
    }

    protected static Map<String, ?> extractMap(Map<String, ?> map, int index) {
        LinkedHashMap result = new LinkedHashMap();
        Set<Map.Entry<String, ?>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            List<?> value = Domain.asArray(entry.getValue());
            result.put(key, value.get(index));
        }
        return result;
    }

    protected static Double selectValue(Map<String, ?> values, String key) {
        return Domain.selectValue(values, key, null);
    }

    protected static Double selectValue(Map<String, ?> values, String key, Double defaultValue) {
        Number value = (Number)values.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ValueUtil.asDouble((Number)value);
    }

    protected static List<?> asArray(Object object) {
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayContent();
        }
        if (object instanceof Number) {
            return Collections.singletonList(object);
        }
        throw new IllegalArgumentException(ClassDictUtil.formatClass(object) + " is not a supported array type");
    }
}

