/*
 * Decompiled with CFR 0.152.
 */
package sklearn.feature_selection;

import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn.Selector;

public class SelectKBest
extends Selector {
    public SelectKBest(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getScoresShape();
        return shape[0];
    }

    @Override
    public List<Boolean> getSupportMask() {
        Object k = this.getK();
        List<? extends Number> scores = this.getScores();
        if ("all".equals(k)) {
            return null;
        }
        ArrayList<Entry<Integer>> entries = new ArrayList<Entry<Integer>>();
        for (int i = 0; i < scores.size(); ++i) {
            Number score = scores.get(i);
            double doubleScore = score.doubleValue();
            if (Double.isNaN(doubleScore)) {
                doubleScore = -1.7976931348623157E308;
            }
            Entry<Integer> entry = new Entry<Integer>(i, doubleScore);
            entries.add(entry);
        }
        Collections.sort(entries);
        boolean[] result = new boolean[scores.size()];
        int max = ValueUtil.asInt((Number)((Number)k));
        for (int i = 0; i < max; ++i) {
            Entry entry = (Entry)entries.get(entries.size() - (i + 1));
            result[((Integer)entry.getId()).intValue()] = true;
        }
        return Booleans.asList((boolean[])result);
    }

    public Object getK() {
        return this.get("k");
    }

    public List<? extends Number> getScores() {
        return ClassDictUtil.getArray(this, "scores_");
    }

    private int[] getScoresShape() {
        return ClassDictUtil.getShape(this, "scores_", 1);
    }

    private static class Entry<E>
    implements Comparable<Entry<E>> {
        private E id;
        private double score;

        public Entry(E id, double score) {
            this.setId(id);
            this.setScore(score);
        }

        @Override
        public int compareTo(Entry<E> that) {
            return Double.compare(this.getScore(), that.getScore());
        }

        public E getId() {
            return this.id;
        }

        private void setId(E id) {
            this.id = id;
        }

        public double getScore() {
            return this.score;
        }

        private void setScore(double score) {
            this.score = score;
        }
    }
}

