/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Row;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.DOMUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class LookupTransformer
extends Transformer {
    public LookupTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        Map<?, ?> mapping = this.getMapping();
        ArrayList inputValues = new ArrayList(mapping.keySet());
        return TypeUtil.getDataType(inputValues, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Map<?, ?> mapping = this.getMapping();
        Object defaultValue = this.getDefaultValue();
        ClassDictUtil.checkSize(1, features);
        Feature feature = features.get(0);
        ArrayList<Object> outputValues = new ArrayList<Object>(mapping.size() + 1);
        DocumentBuilder documentBuilder = DOMUtil.createDocumentBuilder();
        InlineTable inlineTable = new InlineTable();
        List<String> columns = Arrays.asList("input", "output");
        Set<Map.Entry<?, ?>> entries = mapping.entrySet();
        for (Map.Entry entry : entries) {
            Object inputValue = entry.getKey();
            Object outputValue = entry.getValue();
            if (outputValue == null) continue;
            List<String> values = Arrays.asList(ValueUtil.formatValue(inputValue), ValueUtil.formatValue(outputValue));
            Row row = DOMUtil.createRow((DocumentBuilder)documentBuilder, columns, values);
            inlineTable.addRows(new Row[]{row});
            outputValues.add(outputValue);
        }
        MapValues mapValues = new MapValues().addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(feature.getName(), columns.get(0))}).setOutputColumn(columns.get(1)).setInlineTable(inlineTable);
        if (defaultValue != null) {
            mapValues.setDefaultValue(ValueUtil.formatValue((Object)defaultValue));
            outputValues.add(defaultValue);
        }
        DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"lookup", (Feature)feature), OpType.CATEGORICAL, TypeUtil.getDataType(outputValues, DataType.STRING), (Expression)mapValues);
        feature = new Feature((PMMLEncoder)encoder, derivedField.getName(), derivedField.getDataType()){

            public ContinuousFeature toContinuousFeature() {
                PMMLEncoder encoder = this.getEncoder();
                DerivedField derivedField = (DerivedField)encoder.toContinuous(this.getName());
                return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
            }
        };
        return Collections.singletonList(feature);
    }

    public Map<?, ?> getMapping() {
        return (Map)this.get("mapping");
    }

    public Object getDefaultValue() {
        return this.get("default_value");
    }
}

