/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import sklearn.Classifier;
import sklearn.ClassifierUtil;

public abstract class BaseLinearClassifier
extends Classifier {
    public BaseLinearClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getCoefShape();
        return shape[1];
    }

    public RegressionModel encodeModel(Schema schema) {
        int[] shape = this.getCoefShape();
        int numberOfClasses = shape[0];
        int numberOfFeatures = shape[1];
        boolean hasProbabilityDistribution = this.hasProbabilityDistribution();
        List<? extends Number> coef = this.getCoef();
        List<? extends Number> intercepts = this.getIntercept();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        List features = schema.getFeatures();
        if (numberOfClasses == 1) {
            ClassifierUtil.checkSize(2, categoricalLabel);
            return RegressionModelUtil.createBinaryLogisticClassification((List)features, (List)ValueUtil.asDoubles((List)CMatrixUtil.getRow(coef, (int)numberOfClasses, (int)numberOfFeatures, (int)0)), (Double)ValueUtil.asDouble((Number)intercepts.get(0)), (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.LOGIT, (boolean)hasProbabilityDistribution, (Schema)schema);
        }
        if (numberOfClasses >= 3) {
            ClassifierUtil.checkSize(numberOfClasses, categoricalLabel);
            ArrayList<RegressionTable> regressionTables = new ArrayList<RegressionTable>();
            int rows = categoricalLabel.size();
            for (int i = 0; i < rows; ++i) {
                RegressionTable regressionTable = RegressionModelUtil.createRegressionTable((List)features, (List)ValueUtil.asDoubles((List)CMatrixUtil.getRow(coef, (int)numberOfClasses, (int)numberOfFeatures, (int)i)), (Double)ValueUtil.asDouble((Number)intercepts.get(i))).setTargetCategory(categoricalLabel.getValue(i));
                regressionTables.add(regressionTable);
            }
            RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), regressionTables).setNormalizationMethod(RegressionModel.NormalizationMethod.LOGIT).setOutput(hasProbabilityDistribution ? ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (CategoricalLabel)categoricalLabel) : null);
            return regressionModel;
        }
        throw new IllegalArgumentException();
    }

    public List<? extends Number> getCoef() {
        return this.getArray("coef_", Number.class);
    }

    public int[] getCoefShape() {
        return this.getArrayShape("coef_", 2);
    }

    public List<? extends Number> getIntercept() {
        return this.getArray("intercept_", Number.class);
    }
}

