/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model;

import com.google.common.collect.Iterables;
import java.util.List;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import sklearn.Regressor;

public abstract class BaseLinearRegressor
extends Regressor {
    public BaseLinearRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getCoefShape();
        return shape[0];
    }

    public RegressionModel encodeModel(Schema schema) {
        List<? extends Number> coef = this.getCoef();
        List<? extends Number> intercept = this.getIntercept();
        return RegressionModelUtil.createRegression((List)schema.getFeatures(), (List)ValueUtil.asDoubles(coef), (Double)ValueUtil.asDouble((Number)((Number)Iterables.getOnlyElement(intercept))), null, (Schema)schema);
    }

    public List<? extends Number> getCoef() {
        return this.getArray("coef_", Number.class);
    }

    public int[] getCoefShape() {
        return this.getArrayShape("coef_", 1);
    }

    public List<? extends Number> getIntercept() {
        return this.getArray("intercept_", Number.class);
    }
}

