/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Row;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.DOMUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class LookupTransformer
extends Transformer {
    public LookupTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        Map<?, ?> mapping = this.getMapping();
        ArrayList inputValues = new ArrayList(mapping.keySet());
        return TypeUtil.getDataType(inputValues, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Feature feature;
        Map<?, ?> mapping = this.getMapping();
        Object defaultValue = this.getDefaultValue();
        ArrayList<String> columns = new ArrayList<String>();
        columns.addAll(this.createInputColumns(features));
        if (columns.contains("output")) {
            throw new IllegalArgumentException();
        }
        columns.add("output");
        ArrayList<Object> outputValues = new ArrayList<Object>(mapping.size() + 1);
        DocumentBuilder documentBuilder = DOMUtil.createDocumentBuilder();
        InlineTable inlineTable = new InlineTable();
        Set<Map.Entry<?, ?>> entries = mapping.entrySet();
        for (Map.Entry entry : entries) {
            Row row;
            Object inputValue = entry.getKey();
            Object outputValue = entry.getValue();
            if (outputValue == null || (row = this.createRow(documentBuilder, columns, inputValue, outputValue)) == null) continue;
            inlineTable.addRows(new Row[]{row});
            outputValues.add(outputValue);
        }
        StringBuilder sb = new StringBuilder();
        MapValues mapValues = new MapValues().setInlineTable(inlineTable);
        for (int i = 0; i < features.size(); ++i) {
            feature = features.get(i);
            String column = (String)columns.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(FeatureUtil.getName((Feature)feature).getValue());
            mapValues.addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(feature.getName(), column)});
        }
        mapValues.setOutputColumn((String)columns.get(columns.size() - 1));
        if (defaultValue != null) {
            mapValues.setDefaultValue(ValueUtil.formatValue((Object)defaultValue));
            outputValues.add(defaultValue);
        }
        DerivedField derivedField = encoder.createDerivedField(FieldName.create((String)("lookup(" + sb.toString() + ")")), OpType.CATEGORICAL, TypeUtil.getDataType(outputValues, DataType.STRING), (Expression)mapValues);
        feature = new Feature((PMMLEncoder)encoder, derivedField.getName(), derivedField.getDataType()){

            public ContinuousFeature toContinuousFeature() {
                PMMLEncoder encoder = this.getEncoder();
                DerivedField derivedField = (DerivedField)encoder.toContinuous(this.getName());
                return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
            }
        };
        return Collections.singletonList(feature);
    }

    protected List<String> createInputColumns(List<Feature> features) {
        ClassDictUtil.checkSize(1, features);
        return Collections.singletonList("input");
    }

    protected Row createRow(DocumentBuilder documentBuilder, List<String> columns, Object inputValue, Object outputValue) {
        List<String> values = Arrays.asList(ValueUtil.formatValue((Object)inputValue), ValueUtil.formatValue((Object)outputValue));
        return DOMUtil.createRow((DocumentBuilder)documentBuilder, columns, values);
    }

    public Map<?, ?> getMapping() {
        return this.get("mapping", Map.class);
    }

    public Object getDefaultValue() {
        return this.get("default_value");
    }
}

