/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ValueUtil;
import sklearn.Estimator;
import sklearn.HasClasses;

public class ClassifierUtil {
    private ClassifierUtil() {
    }

    public static List<?> getClasses(Estimator estimator) {
        HasClasses hasClasses = (HasClasses)((Object)estimator);
        return hasClasses.getClasses();
    }

    public static List<String> formatTargetCategories(List<?> objects) {
        Function<Object, String> function = new Function<Object, String>(){

            public String apply(Object object) {
                String targetCategory = ValueUtil.formatValue((Object)object);
                if (targetCategory == null || "".equals(targetCategory)) {
                    throw new IllegalArgumentException(targetCategory);
                }
                if (!targetCategory.equals(targetCategory.trim())) {
                    throw new IllegalArgumentException(targetCategory);
                }
                return targetCategory;
            }
        };
        return Lists.transform(objects, (Function)function);
    }

    public static void checkSize(int size, CategoricalLabel categoricalLabel) {
        if (categoricalLabel.size() != size) {
            throw new IllegalArgumentException("Expected " + size + " class(es), got " + categoricalLabel.size() + " class(es)");
        }
    }
}

