/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;

public class TypeUtil {
    private static final Map<Class<?>, DataType> dataTypes = new LinkedHashMap();

    private TypeUtil() {
    }

    public static DataType getDataType(List<?> objects, DataType defaultDataType) {
        Function function = new Function<Object, Class<?>>(){

            public Class<?> apply(Object object) {
                return object.getClass();
            }
        };
        HashSet clazzes = new HashSet(Lists.transform(objects, (Function)function));
        if (clazzes.size() > 1) {
            clazzes.remove(String.class);
        }
        if (clazzes.size() > 1) {
            throw new IllegalArgumentException("Expected all values to be of the same data type, got " + clazzes.size() + " different data types (" + clazzes + ")");
        }
        Class clazz = (Class)Iterables.getOnlyElement(clazzes);
        DataType dataType = dataTypes.get(clazz);
        if (dataType != null) {
            return dataType;
        }
        return defaultDataType;
    }

    static {
        dataTypes.put(Boolean.class, DataType.BOOLEAN);
        dataTypes.put(Byte.class, DataType.INTEGER);
        dataTypes.put(Short.class, DataType.INTEGER);
        dataTypes.put(Integer.class, DataType.INTEGER);
        dataTypes.put(Long.class, DataType.INTEGER);
        dataTypes.put(Float.class, DataType.FLOAT);
        dataTypes.put(Double.class, DataType.DOUBLE);
    }
}

