/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class LabelBinarizer
extends Transformer {
    public LabelBinarizer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<?> classes = this.getClasses();
        return TypeUtil.getDataType(classes, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<?> classes = this.getClasses();
        Number negLabel = this.getNegLabel();
        Number posLabel = this.getPosLabel();
        ClassDictUtil.checkSize(1, features);
        Feature feature = features.get(0);
        ArrayList<String> categories = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            Object value = classes.get(i);
            String category = ValueUtil.formatValue(value);
            categories.add(category);
        }
        ArrayList<String> labelCategories = new ArrayList<String>();
        labelCategories.add(ValueUtil.formatValue((Number)negLabel));
        labelCategories.add(ValueUtil.formatValue((Number)posLabel));
        ArrayList<Feature> result = new ArrayList<Feature>();
        classes = this.prepareClasses(classes);
        for (int i = 0; i < classes.size(); ++i) {
            Object value = classes.get(i);
            String category = ValueUtil.formatValue(value);
            if (ValueUtil.isZero((Number)negLabel) && ValueUtil.isOne((Number)posLabel)) {
                result.add((Feature)new BinaryFeature((PMMLEncoder)encoder, feature.getName(), DataType.STRING, category));
                continue;
            }
            Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{feature.ref(), PMMLUtil.createConstant(value)}), PMMLUtil.createConstant((Object)posLabel), PMMLUtil.createConstant((Object)negLabel)});
            FieldName name = classes.size() > 1 ? FeatureUtil.createName((String)"label_binarizer", (Feature)feature, (int)i) : FeatureUtil.createName((String)"label_binarizer", (Feature)feature);
            DerivedField derivedField = encoder.createDerivedField(name, (Expression)apply);
            result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField, labelCategories));
        }
        encoder.toCategorical(feature.getName(), categories);
        return result;
    }

    protected List<?> prepareClasses(List<?> classes) {
        if (classes.size() < 2) {
            throw new IllegalArgumentException();
        }
        if (classes.size() == 2) {
            classes = classes.subList(1, 2);
        }
        return classes;
    }

    public List<?> getClasses() {
        return this.getArray("classes_");
    }

    public Number getPosLabel() {
        return (Number)this.get("pos_label");
    }

    public Number getNegLabel() {
        return (Number)this.get("neg_label");
    }
}

