/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Interval;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class CutTransformer
extends Transformer {
    public CutTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> bins = this.getBins();
        List<String> labels = this.getLabels();
        Boolean right = this.getRight();
        Boolean includeLowest = this.getIncludeLowest();
        ClassDictUtil.checkSize(1, features);
        if (labels != null) {
            ClassDictUtil.checkSize(bins.size() - 1, labels);
        }
        Feature feature = features.get(0);
        Interval.Closure closure = right != false ? Interval.Closure.OPEN_CLOSED : Interval.Closure.CLOSED_OPEN;
        ContinuousFeature continuousFeature = feature.toContinuousFeature();
        ArrayList<String> categories = new ArrayList<String>();
        Discretize discretize = new Discretize(continuousFeature.getName());
        for (int i = 0; i < bins.size() - 1; ++i) {
            Number leftMargin = bins.get(i);
            Number rightMargin = bins.get(i + 1);
            Interval interval = new Interval(closure).setLeftMargin(CutTransformer.formatMargin(leftMargin)).setRightMargin(CutTransformer.formatMargin(rightMargin));
            if (i == 0 && includeLowest.booleanValue() && interval.getClosure().equals((Object)Interval.Closure.OPEN_CLOSED)) {
                interval.setClosure(Interval.Closure.CLOSED_CLOSED);
            }
            String label = labels != null ? labels.get(i) : String.valueOf(i);
            categories.add(label);
            DiscretizeBin discretizeBin = new DiscretizeBin(label, interval);
            discretize.addDiscretizeBins(new DiscretizeBin[]{discretizeBin});
        }
        DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"cut", (Feature)feature), OpType.CATEGORICAL, labels != null ? DataType.STRING : DataType.INTEGER, (Expression)discretize);
        return Collections.singletonList(new CategoricalFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField, categories));
    }

    public List<? extends Number> getBins() {
        return this.getList("bins", Number.class);
    }

    public List<String> getLabels() {
        Object labels = this.get("labels");
        if (labels == null || Boolean.FALSE.equals(labels)) {
            return null;
        }
        return this.getList("labels", String.class);
    }

    public Boolean getRight() {
        return (Boolean)this.get("right");
    }

    public Boolean getIncludeLowest() {
        return (Boolean)this.get("include_lowest");
    }

    private static Double formatMargin(Number number) {
        double value = number.doubleValue();
        if (Double.isInfinite(value)) {
            return null;
        }
        return value;
    }
}

