/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PowerFeature;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class PowerFunctionTransformer
extends Transformer {
    public PowerFunctionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Integer power = this.getPower();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Feature feature : features) {
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                result.add((Feature)binaryFeature);
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            result.add((Feature)new PowerFeature((PMMLEncoder)encoder, continuousFeature.getName(), continuousFeature.getDataType(), power.intValue()));
        }
        return result;
    }

    public Integer getPower() {
        return (Integer)this.get("power");
    }
}

