/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class StringNormalizer
extends Transformer {
    public StringNormalizer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        String function = this.getFunction();
        Boolean trimBlanks = this.getTrimBlanks();
        if (function == null && !trimBlanks.booleanValue()) {
            return features;
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Feature feature : features) {
            FieldRef expression = feature.ref();
            if (function != null) {
                expression = PMMLUtil.createApply((String)function, (Expression[])new Expression[]{expression});
            }
            if (trimBlanks.booleanValue()) {
                expression = PMMLUtil.createApply((String)"trimBlanks", (Expression[])new Expression[]{expression});
            }
            TypeDefinitionField field = encoder.toCategorical(feature.getName(), Collections.emptyList());
            field.setDataType(DataType.STRING);
            DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"normalize", (Feature)feature), OpType.CATEGORICAL, DataType.STRING, (Expression)expression);
            feature = new Feature((PMMLEncoder)encoder, derivedField.getName(), derivedField.getDataType()){

                public ContinuousFeature toContinuousFeature() {
                    throw new UnsupportedOperationException();
                }
            };
            result.add(feature);
        }
        return result;
    }

    public String getFunction() {
        return (String)this.get("function");
    }

    public Boolean getTrimBlanks() {
        return (Boolean)this.get("trim_blanks");
    }
}

