/*
 * Decompiled with CFR 0.152.
 */
package xgboost.sklearn;

import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;
import sklearn.Estimator;
import xgboost.sklearn.Booster;
import xgboost.sklearn.HasBooster;
import xgboost.sklearn.HasXGBoostOptions;

public class BoosterUtil {
    private BoosterUtil() {
    }

    public static <E extends Estimator> int getNumberOfFeatures(E estimator) {
        Learner learner = BoosterUtil.getLearner((HasBooster)((Object)estimator));
        return learner.getNumFeatures();
    }

    public static <E extends Estimator & HasXGBoostOptions> MiningModel encodeBooster(E estimator, Schema schema) {
        Learner learner = BoosterUtil.getLearner((HasBooster)estimator);
        Integer ntreeLimit = (Integer)estimator.getOption("ntree_limit", null);
        Boolean compact = (Boolean)estimator.getOption("compact", Boolean.TRUE);
        Schema xgbSchema = XGBoostUtil.toXGBoostSchema((Schema)schema);
        MiningModel miningModel = learner.encodeMiningModel(ntreeLimit, compact.booleanValue(), xgbSchema);
        return miningModel;
    }

    private static Learner getLearner(HasBooster hasBooster) {
        Booster booster = hasBooster.getBooster();
        return booster.getLearner();
    }
}

