/* ExpressionTranslator.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionTranslator.java */
package org.jpmml.sklearn;

import java.util.ArrayList;
import java.util.List;

import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.Feature;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.model.ValueUtil;

public class ExpressionTranslator extends AbstractTranslator implements ExpressionTranslatorConstants {

        static
        public Expression translate(String string, List<? extends Feature> features){
                return translate(string, features, true);
        }

        static
        public Expression translate(String string, List<? extends Feature> features, boolean compact){
                Expression expression;

                try {
                        ExpressionTranslator expressionTranslator = new ExpressionTranslator(string);
                        expressionTranslator.setFeatures(features);

                        expression = expressionTranslator.translateExpressionInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException("Python expression \'" + string + "\' is either invalid or not supported", pe);
                }

                if(compact){
                        ExpressionCompactor compactor = new ExpressionCompactor();

                        compactor.applyTo(expression);
                }

                return expression;
        }

        static
        private String translateRelationalOperator(Token operator){

                switch(operator.kind){
                        case EQUAL:
                                return "equal";
                        case NOT_EQUAL:
                                return "notEqual";
                        case LESS_THAN:
                                return "lessThan";
                        case LESS_OR_EQUAL:
                                return "lessOrEqual";
                        case GREATER_THAN:
                                return "greaterThan";
                        case GREATER_OR_EQUAL:
                                return "greaterOrEqual";
                        default:
                                throw new IllegalArgumentException(operator.image);
                }
        }

        static
        private String translateArithmeticOperator(Token operator){

                switch(operator.kind){
                        case MODULO:
                                return "x-modulo";
                        default:
                                return operator.image;
                }
        }

        static
        private Apply translateFunction(String function, List<Expression> arguments){

                switch(function){
                        case "pandas.isnull":
                                if(arguments.size() != 1){
                                        throw new IllegalArgumentException();
                                }
                                return createApply("isMissing", arguments.get(0));
                        case "pandas.notnull":
                                if(arguments.size() != 1){
                                        throw new IllegalArgumentException();
                                }
                                return createApply("isNotMissing", arguments.get(0));
                        default:
                                throw new IllegalArgumentException(function);
                }
        }

        static
        private String translateValue(Token value){
                String image = value.image;

                switch(value.kind){
                        case FALSE:
                        case TRUE:
                                image = image.toLowerCase();
                                break;
                        case INT:
                                if(image.endsWith("l") || image.endsWith("L")){
                                        image = image.substring(0, image.length() - 1);
                                }
                                break;
                        case STRING:
                                image = image.substring(1, image.length() - 1);
                                break;
                        default:
                                break;
                }

                return image;
        }

        static
        private Apply createApply(String function, Expression... expressions){
                Apply apply = new Apply(function);

                for(Expression expression : expressions){
                        apply.addExpressions(expression);
                }

                return apply;
        }

  final private Expression translateExpressionInternal() throws ParseException {Expression expression;
    expression = Expression();
    jj_consume_token(0);
return expression;
  }

  final public Expression Expression() throws ParseException {Expression expression;
    expression = IfElseExpression();
return expression;
  }

  final public Expression IfElseExpression() throws ParseException {Expression left;
        Expression center;
        Expression right;
    left = LogicalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      center = LogicalOrExpression();
      jj_consume_token(ELSE);
      right = LogicalOrExpression();
left = createApply("if", center, left, right);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
return left;
  }

  final public Expression LogicalOrExpression() throws ParseException {Expression left;
        Expression right;
    left = LogicalAndExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
      right = LogicalAndExpression();
left = createApply("or", left, right);
    }
return left;
  }

  final public Expression LogicalAndExpression() throws ParseException {Expression left;
        Expression right;
    left = NegationExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
      right = NegationExpression();
left = createApply("and", left, right);
    }
return left;
  }

  final public Expression NegationExpression() throws ParseException {Token operator = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      operator = jj_consume_token(NOT);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    expression = ComparisonExpression();
if(operator != null){
                        return createApply("not", expression);
                }

                return expression;
  }

  final public Expression ComparisonExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = AdditiveExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EQUAL:
    case NOT_EQUAL:
    case LESS_THAN:
    case LESS_OR_EQUAL:
    case GREATER_THAN:
    case GREATER_OR_EQUAL:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQUAL:{
        operator = jj_consume_token(EQUAL);
        break;
        }
      case NOT_EQUAL:{
        operator = jj_consume_token(NOT_EQUAL);
        break;
        }
      case LESS_THAN:{
        operator = jj_consume_token(LESS_THAN);
        break;
        }
      case LESS_OR_EQUAL:{
        operator = jj_consume_token(LESS_OR_EQUAL);
        break;
        }
      case GREATER_THAN:{
        operator = jj_consume_token(GREATER_THAN);
        break;
        }
      case GREATER_OR_EQUAL:{
        operator = jj_consume_token(GREATER_OR_EQUAL);
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = AdditiveExpression();
left = createApply(translateRelationalOperator(operator), left, right);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
return left;
  }

  final public Expression AdditiveExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = MultiplicativeExpression();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        operator = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        operator = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
left = createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
  }

  final public Expression MultiplicativeExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = UnaryExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULO:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:{
        operator = jj_consume_token(MULTIPLY);
        break;
        }
      case DIVIDE:{
        operator = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        operator = jj_consume_token(MODULO);
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
left = createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
  }

  final public Expression UnaryExpression() throws ParseException {Token sign = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      sign = jj_consume_token(PLUS);
      expression = UnaryExpression();
      break;
      }
    case MINUS:{
      sign = jj_consume_token(MINUS);
      expression = UnaryExpression();
      break;
      }
    case LPAREN:
    case FALSE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:{
      expression = PrimaryExpression();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(sign != null && sign.kind == MINUS){

                        if(expression instanceof Constant){
                                Constant constant = (Constant)expression;

                                String string = ValueUtil.toString(constant.getValue());
                                if(string.startsWith("-")){
                                        string = string.substring(1);
                                } else

                                {
                                        string = ("-" + string);
                                }

                                constant.setValue(string);
                        } else

                        {
                                Constant constant = new Constant()
                                        .setValue("-1");

                                expression = createApply("*", constant, expression);
                        }
                }

                return expression;
  }

  final public Expression PrimaryExpression() throws ParseException {Expression expression;
    if (jj_2_1(2147483647)) {
      expression = ArrayIndexingExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:{
        expression = FunctionInvocationExpression();
        break;
        }
      case LPAREN:{
        expression = ParenthesizedExpression();
        break;
        }
      case FALSE:
      case TRUE:
      case INT:
      case FLOAT:
      case STRING:{
        expression = LiteralExpression();
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expression;
  }

  final public FieldRef ArrayIndexingExpression() throws ParseException {Token variable;
        Token column;
    if (jj_2_2(2147483647)) {
      variable = jj_consume_token(NAME);
      jj_consume_token(LBRACKET);
      column = jj_consume_token(INT);
      jj_consume_token(RBRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:{
        variable = jj_consume_token(NAME);
        jj_consume_token(LBRACKET);
        column = jj_consume_token(STRING);
        jj_consume_token(RBRACKET);
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if(!("X").equals(variable.image)){
                        {if (true) throw new IllegalArgumentException(variable.image);}
                }

                Feature feature;

                switch(column.kind){
                        case ExpressionTranslatorConstants.INT:
                                {
                                        int index = Integer.parseInt(column.image);

                                        feature = getFeature(index);
                                }
                                break;
                        case ExpressionTranslatorConstants.STRING:
                                {
                                        FieldName name = FieldName.create(column.image.substring(1, column.image.length() - 1));

                                        feature = getFeature(name);
                                }
                                break;
                        default:
                                {if (true) throw new IllegalArgumentException();}
                }

                return feature.ref();
  }

  final public Expression FunctionInvocationExpression() throws ParseException {Token name;
        StringBuilder function = new StringBuilder();
        List<Expression> arguments;
    name = jj_consume_token(NAME);
function.append(name.image);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_5;
      }
      jj_consume_token(DOT);
      name = jj_consume_token(NAME);
function.append('.').append(name.image);
    }
    jj_consume_token(LPAREN);
    arguments = ArgumentList();
    jj_consume_token(RPAREN);
return translateFunction(function.toString(), arguments);
  }

  final public List<Expression> ArgumentList() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    expression = Expression();
expressions.add(expression);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_6;
      }
      jj_consume_token(COMMA);
      expression = Expression();
expressions.add(expression);
    }
return expressions;
  }

  final public Expression ParenthesizedExpression() throws ParseException {Expression expression;
    jj_consume_token(LPAREN);
    expression = Expression();
    jj_consume_token(RPAREN);
return expression;
  }

  final public Constant LiteralExpression() throws ParseException {Token value;
        DataType dataType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE:{
      value = jj_consume_token(FALSE);
dataType = DataType.BOOLEAN;
      break;
      }
    case TRUE:{
      value = jj_consume_token(TRUE);
dataType = DataType.BOOLEAN;
      break;
      }
    case INT:{
      value = jj_consume_token(INT);
dataType = DataType.INTEGER;
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
dataType = DataType.DOUBLE;
      break;
      }
    case STRING:{
      value = jj_consume_token(STRING);
dataType = DataType.STRING;
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Constant constant = new Constant()
                        .setValue(translateValue(value))
                        .setDataType(dataType);

                return constant;
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ExpressionTranslatorTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[16];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x20,0x80,0x100,0x200,0xfc00,0xfc00,0xc0000,0xc0000,0x130000,0x130000,0x7e0c0008,0x7e000008,0x20000000,0x1000000,0x800000,0x5e000000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public ExpressionTranslator(Provider stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ExpressionTranslatorTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
      this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
     ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new ExpressionTranslatorTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ExpressionTranslatorTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[35];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 16; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 35; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[token_source.curLexState]);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
