/*
 * Decompiled with CFR 0.152.
 */
package joblib;

import java.io.IOException;
import java.io.InputStream;
import numpy.DType;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import org.jpmml.sklearn.PyClassDict;

public class NumpyArrayWrapper
extends PyClassDict {
    public NumpyArrayWrapper(String module, String name) {
        super(module, name);
    }

    public NDArray toArray(InputStream is) throws IOException {
        DType dtype = this.getDType();
        Object[] shape = this.getShape();
        String order = this.getOrder();
        Object descr = dtype.toDescr();
        Boolean fortranOrder = NumpyArrayWrapper.parseOrder(order);
        Object data = NDArrayUtil.parseData(is, descr, shape);
        NDArray array = new NDArray();
        array.__setstate__(new Object[]{null, shape, descr, fortranOrder, data});
        return array;
    }

    public DType getDType() {
        return (DType)((Object)this.get("dtype"));
    }

    public Object[] getShape() {
        return (Object[])this.get("shape");
    }

    public String getOrder() {
        return (String)this.get("order");
    }

    private static Boolean parseOrder(String order) {
        switch (order) {
            case "C": {
                return Boolean.FALSE;
            }
            case "F": {
                return Boolean.TRUE;
            }
        }
        throw new IllegalArgumentException(order);
    }
}

