/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.Transformer;

public class SkLearnEncoder
extends ModelEncoder {
    private List<Model> transformers = new ArrayList<Model>();

    public PMML encodePMML(Model model) {
        if (this.transformers.size() > 0) {
            ArrayList<Model> models = new ArrayList<Model>(this.transformers);
            models.add(model);
            Schema schema = new Schema(null, Collections.emptyList());
            model = MiningModelUtil.createModelChain(models, (Schema)schema);
        }
        return super.encodePMML(model);
    }

    public void updateFeatures(List<Feature> features, Transformer transformer) {
        DataType dataType;
        OpType opType;
        try {
            opType = transformer.getOpType();
            dataType = transformer.getDataType();
        }
        catch (UnsupportedOperationException uoe) {
            return;
        }
        for (Feature feature : features) {
            if (!(feature instanceof WildcardFeature)) continue;
            WildcardFeature wildcardFeature = (WildcardFeature)feature;
            this.updateType(wildcardFeature.getName(), opType, dataType);
        }
    }

    public void updateType(FieldName name, OpType opType, DataType dataType) {
        DataField dataField = this.getDataField(name);
        if (dataField == null) {
            throw new IllegalArgumentException(name.getValue());
        }
        dataField.setOpType(opType);
        dataField.setDataType(dataType);
    }

    public DataField createDataField(FieldName name) {
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public DerivedField createDerivedField(FieldName name, Expression expression) {
        return this.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
    }

    public void renameFeature(Feature feature, FieldName renamedName) {
        FieldName name = feature.getName();
        DerivedField derivedField = this.getDerivedField(name);
        if (derivedField == null) {
            throw new IllegalArgumentException(name.getValue());
        }
        Map derivedFields = this.getDerivedFields();
        derivedFields.remove(name);
        try {
            Field field = Feature.class.getDeclaredField("name");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(feature, renamedName);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        derivedField.setName(renamedName);
        this.addDerivedField(derivedField);
    }

    public void addTransformer(Model transformer) {
        this.transformers.add(transformer);
    }
}

