/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import numpy.core.NDArray;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.VerificationField;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.PyClassDict;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.TupleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.Classifier;
import sklearn.ClassifierUtil;
import sklearn.Estimator;
import sklearn.HasEstimator;
import sklearn.HasNumberOfFeatures;
import sklearn.Initializer;
import sklearn.Transformer;
import sklearn.TransformerUtil;
import sklearn.TypeUtil;
import sklearn.pipeline.Pipeline;
import sklearn2pmml.pipeline.Verification;

public class PMMLPipeline
extends Pipeline
implements HasEstimator<Estimator> {
    private static final Logger logger = LoggerFactory.getLogger(PMMLPipeline.class);

    public PMMLPipeline() {
        this("sklearn2pmml", "PMMLPipeline");
    }

    public PMMLPipeline(String module, String name) {
        super(module, name);
    }

    public PMML encodePMML() {
        List<? extends Transformer> transformers = this.getTransformers();
        Estimator estimator = this.getEstimator();
        List<String> activeFields = this.getActiveFields();
        ArrayList<String> probabilityFields = null;
        List<String> targetFields = this.getTargetFields();
        String repr = this.getRepr();
        Verification verification = this.getVerification();
        SkLearnEncoder encoder = new SkLearnEncoder();
        ContinuousLabel label = null;
        if (estimator.isSupervised()) {
            String targetField = null;
            if (targetFields != null) {
                ClassDictUtil.checkSize(1, targetFields);
                targetField = targetFields.get(0);
            }
            if (targetField == null) {
                targetField = "y";
                logger.warn("Attribute '" + ClassDictUtil.formatMember(this, "target_fields") + "' is not set. Assuming {} as the name of the target field", (Object)targetField);
            }
            MiningFunction miningFunction = estimator.getMiningFunction();
            switch (miningFunction) {
                case CLASSIFICATION: {
                    List<?> classes = ClassifierUtil.getClasses(estimator);
                    DataType dataType = TypeUtil.getDataType(classes, DataType.STRING);
                    List<String> categories = ClassifierUtil.formatTargetCategories(classes);
                    DataField dataField = encoder.createDataField(FieldName.create((String)targetField), OpType.CATEGORICAL, dataType, categories);
                    label = new CategoricalLabel(dataField);
                    break;
                }
                case REGRESSION: {
                    DataField dataField = encoder.createDataField(FieldName.create((String)targetField), OpType.CONTINUOUS, DataType.DOUBLE);
                    label = new ContinuousLabel(dataField);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        List<Feature> features = new ArrayList<Feature>();
        PyClassDict featureInitializer = estimator;
        try {
            Transformer transformer = TransformerUtil.getHead(transformers);
            if (transformer != null) {
                featureInitializer = transformer;
                if (!(transformer instanceof Initializer)) {
                    features = this.initFeatures(transformer, transformer.getOpType(), transformer.getDataType(), encoder);
                }
                features = this.encodeFeatures(features, encoder);
            } else {
                features = this.initFeatures(estimator, estimator.getOpType(), estimator.getDataType(), encoder);
            }
        }
        catch (UnsupportedOperationException uoe) {
            throw new IllegalArgumentException("The first transformer or estimator object (" + ClassDictUtil.formatClass(featureInitializer) + ") does not specify feature type information", uoe);
        }
        int numberOfFeatures = estimator.getNumberOfFeatures();
        if (numberOfFeatures > -1) {
            ClassDictUtil.checkSize(numberOfFeatures, features);
        }
        Schema schema = new Schema((Label)label, features);
        Model model = estimator.encodeModel(schema);
        if (estimator.isSupervised() && verification != null) {
            VerificationField verificationField;
            Classifier classifier;
            if (activeFields == null) {
                throw new IllegalArgumentException();
            }
            int[] activeValuesShape = verification.getActiveValuesShape();
            int[] targetValuesShape = verification.getTargetValuesShape();
            ClassDictUtil.checkShapes(0, activeValuesShape, targetValuesShape);
            ClassDictUtil.checkShapes(1, activeFields.size(), (int[][])new int[][]{activeValuesShape});
            List<?> activeValues = verification.getActiveValues();
            List<?> targetValues = verification.getTargetValues();
            int[] probabilityValuesShape = null;
            List<? extends Number> probabilityValues = null;
            if (estimator instanceof Classifier && (classifier = (Classifier)estimator).hasProbabilityDistribution() && verification.hasProbabilityValues()) {
                probabilityValuesShape = verification.getProbabilityValuesShape();
                probabilityFields = new ArrayList<String>();
                CategoricalLabel categoricalLabel = (CategoricalLabel)label;
                List values = categoricalLabel.getValues();
                for (String value : values) {
                    probabilityFields.add("probability(" + value + ")");
                }
                ClassDictUtil.checkShapes(0, activeValuesShape, probabilityValuesShape);
                ClassDictUtil.checkShapes(1, probabilityFields.size(), (int[][])new int[][]{probabilityValuesShape});
                probabilityValues = verification.getProbabilityValues();
            }
            Number precision = verification.getPrecision();
            Number zeroThreshold = verification.getZeroThreshold();
            int rows = activeValuesShape[0];
            LinkedHashMap<VerificationField, List> data = new LinkedHashMap<VerificationField, List>();
            if (activeFields != null) {
                for (int i = 0; i < activeFields.size(); ++i) {
                    verificationField = ModelUtil.createVerificationField((FieldName)FieldName.create((String)activeFields.get(i)));
                    data.put(verificationField, CMatrixUtil.getColumn(activeValues, (int)rows, (int)activeFields.size(), (int)i));
                }
            }
            if (probabilityFields != null) {
                for (int i = 0; i < probabilityFields.size(); ++i) {
                    verificationField = ModelUtil.createVerificationField((FieldName)FieldName.create((String)((String)probabilityFields.get(i)))).setPrecision(Double.valueOf(precision.doubleValue())).setZeroThreshold(Double.valueOf(zeroThreshold.doubleValue()));
                    data.put(verificationField, CMatrixUtil.getColumn(probabilityValues, (int)rows, (int)probabilityFields.size(), (int)i));
                }
            } else {
                for (int i = 0; i < targetFields.size(); ++i) {
                    verificationField = ModelUtil.createVerificationField((FieldName)FieldName.create((String)targetFields.get(i)));
                    DataType dataType = label.getDataType();
                    switch (dataType) {
                        case DOUBLE: 
                        case FLOAT: {
                            verificationField.setPrecision(Double.valueOf(precision.doubleValue())).setZeroThreshold(Double.valueOf(zeroThreshold.doubleValue()));
                            break;
                        }
                    }
                    data.put(verificationField, CMatrixUtil.getColumn(targetValues, (int)rows, (int)targetFields.size(), (int)i));
                }
            }
            model.setModelVerification(ModelUtil.createModelVerification(data));
        }
        PMML pmml = encoder.encodePMML(model);
        if (repr != null) {
            Extension extension = new Extension().addContent(new Object[]{repr});
            MiningBuildTask miningBuildTask = new MiningBuildTask().addExtensions(new Extension[]{extension});
            pmml.setMiningBuildTask(miningBuildTask);
        }
        return pmml;
    }

    private List<Feature> initFeatures(PyClassDict object, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        List<String> activeFields = this.getActiveFields();
        if (activeFields == null) {
            int numberOfFeatures = -1;
            if (object instanceof HasNumberOfFeatures) {
                HasNumberOfFeatures hasNumberOfFeatures = (HasNumberOfFeatures)((Object)object);
                numberOfFeatures = hasNumberOfFeatures.getNumberOfFeatures();
            }
            if (numberOfFeatures < 0) {
                throw new IllegalArgumentException("The first transformer or estimator object (" + ClassDictUtil.formatClass((Object)object) + ") does not specify the number of input features");
            }
            activeFields = new ArrayList<String>(numberOfFeatures);
            int max = numberOfFeatures;
            for (int i = 0; i < max; ++i) {
                activeFields.add("x" + String.valueOf(i + 1));
            }
            logger.warn("Attribute '" + ClassDictUtil.formatMember(this, "active_fields") + "' is not set. Assuming {} as the names of active fields", activeFields);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String activeField : activeFields) {
            DataField dataField = encoder.createDataField(FieldName.create((String)activeField), opType, dataType);
            result.add((Feature)new WildcardFeature((PMMLEncoder)encoder, dataField));
        }
        return result;
    }

    @Override
    public List<? extends Transformer> getTransformers() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() > 0) {
            steps = steps.subList(0, steps.size() - 1);
        }
        return TupleUtil.extractElementList(steps, 1, Transformer.class);
    }

    @Override
    public Estimator getEstimator() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            throw new IllegalArgumentException("Expected one or more elements, got zero elements");
        }
        Object[] lastStep = steps.get(steps.size() - 1);
        return TupleUtil.extractElement(lastStep, 1, Estimator.class);
    }

    @Override
    public List<Object[]> getSteps() {
        return super.getSteps();
    }

    public PMMLPipeline setSteps(List<Object[]> steps) {
        this.put("steps", steps);
        return this;
    }

    public List<String> getActiveFields() {
        if (!this.containsKey("active_fields")) {
            return null;
        }
        return this.getArray("active_fields", String.class);
    }

    public PMMLPipeline setActiveFields(List<String> activeFields) {
        this.put("active_fields", PMMLPipeline.toArray(activeFields));
        return this;
    }

    public List<String> getTargetFields() {
        if (this.containsKey("target_field")) {
            return Collections.singletonList((String)this.get("target_field"));
        }
        if (!this.containsKey("target_fields")) {
            return null;
        }
        return this.getArray("target_fields", String.class);
    }

    public PMMLPipeline setTargetFields(List<String> targetFields) {
        this.put("target_fields", PMMLPipeline.toArray(targetFields));
        return this;
    }

    public String getRepr() {
        return (String)this.get("repr_");
    }

    public PMMLPipeline setRepr(String repr) {
        this.put("repr_", repr);
        return this;
    }

    public Verification getVerification() {
        return (Verification)((Object)this.get("verification"));
    }

    public PMMLPipeline setVerification(Verification verification) {
        this.put("verification", (Object)verification);
        return this;
    }

    private static NDArray toArray(List<String> strings) {
        NDArray result = new NDArray();
        result.put("data", strings);
        result.put("fortran_order", Boolean.FALSE);
        return result;
    }
}

