/*
 * Copyright (c) 2019 Villu Ruusmann
 *
 * This file is part of JPMML-SkLearn
 *
 * JPMML-SkLearn is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JPMML-SkLearn is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with JPMML-SkLearn.  If not, see <http://www.gnu.org/licenses/>.
 */
package sklearn.ensemble;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.HasArray;

public class EnsembleUtil {

	private EnsembleUtil(){
	}

	static
	public List<List<Integer>> transformEstimatorsFeatures(List<? extends HasArray> estimatorsFeatures){
		Function<HasArray, List<Integer>> function = new Function<HasArray, List<Integer>>(){

			@Override
			public List<Integer> apply(HasArray hasArray){
				return ValueUtil.asIntegers((List)hasArray.getArrayContent());
			}
		};

		return Lists.transform(estimatorsFeatures, function);
	}
}