/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.razorvine.pickle.objects.ClassDictConstructor;
import numpy.core.NDArrayUtil;
import org.jpmml.sklearn.CClassDict;
import org.jpmml.sklearn.HasArray;
import org.jpmml.sklearn.HasContent;

public class NDArray
extends CClassDict
implements HasArray,
HasContent<Object> {
    private Object content = null;
    private static final String[] SETSTATE_ATTRIBUTES = new String[]{"version", "shape", "descr", "fortran_order", "data"};

    public NDArray() {
        this("numpy", "ndarray");
    }

    public NDArray(String module, String name) {
        super(module, name);
    }

    @Override
    public void __init__(Object[] args) {
        if (this.isDefault(args)) {
            return;
        }
        super.__init__(args);
    }

    private boolean isDefault(Object[] args) {
        if (args.length != 3) {
            return false;
        }
        if (args[0] instanceof ClassDictConstructor && args[1] instanceof Object[] && Arrays.equals((Object[])args[1], new Object[]{0})) {
            if (args[2] instanceof String && ((String)args[2]).equals("b")) {
                return true;
            }
            if (args[2] instanceof byte[] && Arrays.equals((byte[])args[2], new byte[]{98})) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void __setstate__(Object[] args) {
        super.__setstate__(NDArray.createAttributeMap(SETSTATE_ATTRIBUTES, args));
    }

    @Override
    public List<?> getArrayContent() {
        return NDArrayUtil.getContent(this);
    }

    @Override
    public int[] getArrayShape() {
        return NDArrayUtil.getShape(this);
    }

    @Override
    public Object getContent() {
        if (this.content == null) {
            this.content = this.loadContent();
        }
        return this.content;
    }

    @Override
    public void clearContent() {
        this.content = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object loadContent() {
        Object[] shape = this.getShape();
        Object descr = this.getDescr();
        Object data = this.getData();
        if (!(data instanceof byte[])) {
            return data;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream((byte[])data);){
            Object object = NDArrayUtil.parseData(is, descr, shape);
            return object;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public Object[] getShape() {
        return (Object[])this.get("shape");
    }

    public Object getDescr() {
        return this.get("descr");
    }

    public Boolean getFortranOrder() {
        return (Boolean)this.get("fortran_order");
    }

    public Object getData() {
        Object data = this.get("data");
        if (data instanceof String) {
            String string = (String)data;
            return string.getBytes(Charsets.ISO_8859_1);
        }
        return data;
    }
}

