/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import numpy.core.UFunc;
import org.dmg.pmml.Expression;
import org.jpmml.converter.PMMLUtil;

public class UFuncUtil {
    private UFuncUtil() {
    }

    public static Expression encodeUFunc(UFunc ufunc, Expression expression) {
        return UFuncUtil.encodeUFunc(ufunc.getModule(), ufunc.getName(), expression);
    }

    public static Expression encodeUFunc(String module, String name, Expression expression) {
        switch (module) {
            case "numpy": {
                return UFuncUtil.encodeNumpyUFunc(name, expression);
            }
        }
        throw new IllegalArgumentException(module);
    }

    private static Expression encodeNumpyUFunc(String name, Expression expression) {
        switch (name) {
            case "absolute": {
                return PMMLUtil.createApply((String)"abs", (Expression[])new Expression[]{expression});
            }
            case "acos": {
                return PMMLUtil.createApply((String)"x-acos", (Expression[])new Expression[]{expression});
            }
            case "asin": {
                return PMMLUtil.createApply((String)"x-asin", (Expression[])new Expression[]{expression});
            }
            case "atan": {
                return PMMLUtil.createApply((String)"x-atan", (Expression[])new Expression[]{expression});
            }
            case "atan2": {
                return PMMLUtil.createApply((String)"x-atan2", (Expression[])new Expression[]{expression});
            }
            case "ceil": {
                return PMMLUtil.createApply((String)"ceil", (Expression[])new Expression[]{expression});
            }
            case "cos": {
                return PMMLUtil.createApply((String)"x-cos", (Expression[])new Expression[]{expression});
            }
            case "cosh": {
                return PMMLUtil.createApply((String)"x-cosh", (Expression[])new Expression[]{expression});
            }
            case "exp": {
                return PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{expression});
            }
            case "expm1": {
                return PMMLUtil.createApply((String)"x-expm1", (Expression[])new Expression[]{expression});
            }
            case "floor": {
                return PMMLUtil.createApply((String)"floor", (Expression[])new Expression[]{expression});
            }
            case "hypot": {
                return PMMLUtil.createApply((String)"x-hypot", (Expression[])new Expression[]{expression});
            }
            case "log": {
                return PMMLUtil.createApply((String)"ln", (Expression[])new Expression[]{expression});
            }
            case "log1p": {
                return PMMLUtil.createApply((String)"x-ln1p", (Expression[])new Expression[]{expression});
            }
            case "log10": {
                return PMMLUtil.createApply((String)"log10", (Expression[])new Expression[]{expression});
            }
            case "negative": {
                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)-1), expression});
            }
            case "reciprocal": {
                return PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)1), expression});
            }
            case "rint": {
                return PMMLUtil.createApply((String)"x-rint", (Expression[])new Expression[]{expression});
            }
            case "sign": {
                return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"lessThan", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)0)}), PMMLUtil.createConstant((Number)-1), PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)0)}), PMMLUtil.createConstant((Number)1), PMMLUtil.createConstant((Number)0)})});
            }
            case "sin": {
                return PMMLUtil.createApply((String)"x-sin", (Expression[])new Expression[]{expression});
            }
            case "sinh": {
                return PMMLUtil.createApply((String)"x-sinh", (Expression[])new Expression[]{expression});
            }
            case "sqrt": {
                return PMMLUtil.createApply((String)"sqrt", (Expression[])new Expression[]{expression});
            }
            case "square": {
                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, expression});
            }
            case "tan": {
                return PMMLUtil.createApply((String)"x-tan", (Expression[])new Expression[]{expression});
            }
            case "tanh": {
                return PMMLUtil.createApply((String)"x-tanh", (Expression[])new Expression[]{expression});
            }
        }
        throw new IllegalArgumentException(name);
    }
}

