/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.dmg.pmml.PMML;
import org.jpmml.model.MetroJAXBUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.PickleUtil;
import org.jpmml.sklearn.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.Estimator;
import sklearn.pipeline.Pipeline;
import sklearn2pmml.pipeline.PMMLPipeline;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--pkl-pipeline-input", "--pkl-input"}, description="Pickle input file", required=true)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        PMML pmml;
        Pipeline pipeline;
        long end;
        Object object;
        long begin;
        try (Storage storage = PickleUtil.createStorage(this.input);){
            logger.info("Parsing PKL..");
            begin = System.currentTimeMillis();
            object = PickleUtil.unpickle(storage);
            end = System.currentTimeMillis();
            logger.info("Parsed PKL in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to parse PKL", (Throwable)e);
            throw e;
        }
        if (!(object instanceof PMMLPipeline)) {
            if (object instanceof Pipeline) {
                pipeline = (Pipeline)object;
                object = new PMMLPipeline().setSteps(pipeline.getSteps());
            } else if (object instanceof Estimator) {
                Estimator estimator = (Estimator)object;
                object = new PMMLPipeline().setSteps(Collections.singletonList(new Object[]{"estimator", estimator}));
            } else {
                throw new IllegalArgumentException("The object (" + ClassDictUtil.formatClass(object) + ") is not a PMMLPipeline");
            }
        }
        pipeline = (PMMLPipeline)object;
        try {
            logger.info("Converting..");
            begin = System.currentTimeMillis();
            pmml = ((PMMLPipeline)pipeline).encodePMML();
            end = System.currentTimeMillis();
            logger.info("Converted in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            long begin2 = System.currentTimeMillis();
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            long end2 = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end2 - begin2));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }
}

