/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.sklearn.ClassDictUtil;
import sklearn2pmml.decoration.Alias;
import sklearn2pmml.decoration.Domain;

public class SkLearnEncoder
extends ModelEncoder {
    private Map<FieldName, Domain> frozenFields = new LinkedHashMap<FieldName, Domain>();

    public DataField createDataField(FieldName name) {
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public DerivedField createDerivedField(FieldName name, Expression expression) {
        return this.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
    }

    public void addDerivedField(DerivedField derivedField) {
        try {
            super.addDerivedField(derivedField);
        }
        catch (RuntimeException re) {
            FieldName name = derivedField.getName();
            String message = "Field " + name.getValue() + " is already defined. Please refactor the pipeline so that it would not contain duplicate field declarations, or use the " + Alias.class.getName() + " wrapper class to override the default name with a custom name (eg. " + ClassDictUtil.formatAliasExample() + ")";
            throw new IllegalArgumentException(message, re);
        }
    }

    public void renameFeature(Feature feature, FieldName renamedName) {
        FieldName name = feature.getName();
        org.dmg.pmml.Field pmmlField = this.getField(name);
        if (pmmlField instanceof DataField) {
            throw new IllegalArgumentException("User input field " + name.getValue() + " cannot be renamed");
        }
        DerivedField derivedField = this.removeDerivedField(name);
        try {
            Field field = Feature.class.getDeclaredField("name");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(feature, renamedName);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        derivedField.setName(renamedName);
        this.addDerivedField(derivedField);
    }

    public boolean isFrozen(FieldName name) {
        return this.frozenFields.containsKey(name);
    }

    public void setFrozen(FieldName name, Domain domain) {
        if (domain != null) {
            this.frozenFields.put(name, domain);
        } else {
            this.frozenFields.remove(name);
        }
    }
}

