/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Iterator;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.PyClassDict;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Estimator;
import sklearn.HasNumberOfFeatures;
import sklearn.HasType;
import sklearn.Transformer;
import sklearn.TransformerUtil;

public abstract class Composite
extends PyClassDict
implements HasNumberOfFeatures,
HasType {
    public Composite(String module, String name) {
        super(module, name);
    }

    public abstract boolean hasTransformers();

    public abstract List<? extends Transformer> getTransformers();

    public abstract boolean hasFinalEstimator();

    public abstract Estimator getFinalEstimator();

    @Override
    public int getNumberOfFeatures() {
        List<? extends Transformer> transformers;
        Iterator<? extends Transformer> iterator;
        if (this.hasTransformers() && (iterator = (transformers = this.getTransformers()).iterator()).hasNext()) {
            Transformer transformer = iterator.next();
            return TransformerUtil.getNumberOfFeatures(transformer);
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getNumberOfFeatures();
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        List<? extends Transformer> transformers;
        Iterator<? extends Transformer> iterator;
        if (this.hasTransformers() && (iterator = (transformers = this.getTransformers()).iterator()).hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getOpType();
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getOpType();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType() {
        List<? extends Transformer> transformers;
        Iterator<? extends Transformer> iterator;
        if (this.hasTransformers() && (iterator = (transformers = this.getTransformers()).iterator()).hasNext()) {
            Transformer transformer = iterator.next();
            return transformer.getDataType();
        }
        if (this.hasFinalEstimator()) {
            Estimator estimator = this.getFinalEstimator();
            return estimator.getDataType();
        }
        throw new UnsupportedOperationException();
    }

    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        if (!this.hasTransformers()) {
            return features;
        }
        List<? extends Transformer> transformers = this.getTransformers();
        for (Transformer transformer : transformers) {
            int numberOfFeatures = TransformerUtil.getNumberOfFeatures(transformer);
            if (numberOfFeatures > -1) {
                ClassDictUtil.checkSize(numberOfFeatures, features);
            }
            features = transformer.updateAndEncodeFeatures(features, encoder);
        }
        return features;
    }

    public Model encodeModel(Schema schema) {
        Label label = schema.getLabel();
        List<Feature> features = schema.getFeatures();
        if (!this.hasFinalEstimator()) {
            throw new UnsupportedOperationException();
        }
        Estimator estimator = this.getFinalEstimator();
        if (this.hasTransformers()) {
            Feature feature = (Feature)features.get(0);
            SkLearnEncoder encoder = (SkLearnEncoder)feature.getEncoder();
            features = this.encodeFeatures(features, encoder);
            schema = new Schema(label, features);
        }
        return estimator.encodeModel(schema);
    }
}

