/*
 * Decompiled with CFR 0.152.
 */
package sklearn.pipeline;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.jpmml.sklearn.CastFunction;
import org.jpmml.sklearn.Castable;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Classifier;
import sklearn.Composite;
import sklearn.Estimator;
import sklearn.PassThrough;
import sklearn.Regressor;
import sklearn.Transformer;
import sklearn.pipeline.PipelineClassifier;
import sklearn.pipeline.PipelineRegressor;
import sklearn.pipeline.PipelineTransformer;

public class Pipeline
extends Composite
implements Castable {
    public Pipeline() {
        this("sklearn.pipeline", "Pipeline");
    }

    public Pipeline(String module, String name) {
        super(module, name);
    }

    @Override
    public boolean hasTransformers() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            return false;
        }
        if (steps.size() == 1) {
            return !this.hasFinalEstimator();
        }
        return true;
    }

    @Override
    public boolean hasFinalEstimator() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            return false;
        }
        Object[] finalStep = steps.get(steps.size() - 1);
        Object estimator = TupleUtil.extractElement(finalStep, 1);
        return "passthrough".equals(estimator) || Estimator.class.isInstance(estimator);
    }

    @Override
    public List<? extends Transformer> getTransformers() {
        List<Object[]> steps = this.getSteps();
        if (this.hasFinalEstimator()) {
            steps = steps.subList(0, steps.size() - 1);
        }
        List<?> transformers = TupleUtil.extractElementList(steps, 1);
        CastFunction<Transformer> castFunction = new CastFunction<Transformer>(Transformer.class){

            @Override
            public Transformer apply(Object object) {
                if ("passthrough".equals(object)) {
                    return PassThrough.INSTANCE;
                }
                return (Transformer)super.apply(object);
            }

            @Override
            public String formatMessage(Object object) {
                return "The transformer object (" + ClassDictUtil.formatClass(object) + ") is not a supported Transformer";
            }
        };
        return Lists.transform(transformers, (Function)castFunction);
    }

    @Override
    public Estimator getFinalEstimator() {
        return this.getFinalEstimator(Estimator.class);
    }

    public <E extends Estimator> E getFinalEstimator(Class<? extends E> clazz) {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            throw new IllegalArgumentException("Expected one or more steps, got zero steps");
        }
        Object[] finalStep = steps.get(steps.size() - 1);
        Object estimator = TupleUtil.extractElement(finalStep, 1);
        CastFunction castFunction = new CastFunction<E>(clazz){

            @Override
            public E apply(Object object) {
                if ("passthrough".equals(object)) {
                    return null;
                }
                return (Estimator)super.apply(object);
            }

            @Override
            public String formatMessage(Object object) {
                return "The transformer object of the final step (" + ClassDictUtil.formatClass(object) + ") is not a supported Estimator";
            }
        };
        return (E)((Estimator)castFunction.apply(estimator));
    }

    @Override
    public Object castTo(Class<?> clazz) {
        if (Transformer.class.equals(clazz)) {
            return this.toTransformer();
        }
        if (Estimator.class.equals(clazz)) {
            return this.toEstimator();
        }
        if (Classifier.class.equals(clazz)) {
            return this.toClassifier();
        }
        if (Regressor.class.equals(clazz)) {
            return this.toRegressor();
        }
        return this;
    }

    public Transformer toTransformer() {
        Estimator estimator;
        if (this.hasFinalEstimator() && (estimator = this.getFinalEstimator()) != null) {
            throw new IllegalArgumentException("The pipeline ends with an estimator object");
        }
        return new PipelineTransformer(this);
    }

    public Estimator toEstimator() {
        Estimator estimator = this.getFinalEstimator();
        if (estimator instanceof Classifier) {
            return this.toClassifier();
        }
        if (estimator instanceof Regressor) {
            return this.toRegressor();
        }
        throw new IllegalArgumentException();
    }

    public Classifier toClassifier() {
        return new PipelineClassifier(this);
    }

    public Regressor toRegressor() {
        return new PipelineRegressor(this);
    }

    public List<Object[]> getSteps() {
        return this.getTupleList("steps");
    }
}

