/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class LabelBinarizer
extends Transformer {
    public LabelBinarizer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<?> classes = this.getClasses();
        return TypeUtil.getDataType(classes, (DataType)DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<?> classes = this.getClasses();
        Number negLabel = this.getNegLabel();
        Number posLabel = this.getPosLabel();
        ClassDictUtil.checkSize(1, features);
        Feature feature = features.get(0);
        ArrayList categories = new ArrayList();
        categories.addAll(classes);
        ArrayList<Number> labelCategories = new ArrayList<Number>();
        labelCategories.add(negLabel);
        labelCategories.add(posLabel);
        ArrayList<Feature> result = new ArrayList<Feature>();
        classes = this.prepareClasses(classes);
        for (int i = 0; i < classes.size(); ++i) {
            Object value = classes.get(i);
            if (ValueUtil.isZero((Number)negLabel) && ValueUtil.isOne((Number)posLabel)) {
                result.add((Feature)new BinaryFeature((PMMLEncoder)encoder, feature, value));
                continue;
            }
            Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[0]).addExpressions(new Expression[]{PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{feature.ref(), PMMLUtil.createConstant(value, (DataType)feature.getDataType())})}).addExpressions(new Expression[]{PMMLUtil.createConstant((Number)posLabel), PMMLUtil.createConstant((Number)negLabel)});
            FieldName name = classes.size() > 1 ? FeatureUtil.createName((String)"label_binarizer", (Feature)feature, (int)i) : FeatureUtil.createName((String)"label_binarizer", (Feature)feature);
            DerivedField derivedField = encoder.createDerivedField(name, (Expression)apply);
            result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, (Field)derivedField, labelCategories));
        }
        encoder.toCategorical(feature.getName(), categories);
        return result;
    }

    protected List<?> prepareClasses(List<?> classes) {
        if (classes.size() < 2) {
            throw new IllegalArgumentException();
        }
        if (classes.size() == 2) {
            classes = classes.subList(1, 2);
        }
        return classes;
    }

    public List<?> getClasses() {
        return this.getArray("classes_");
    }

    public Number getPosLabel() {
        return this.getNumber("pos_label");
    }

    public Number getNegLabel() {
        return this.getNumber("neg_label");
    }
}

