/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;

public class StandardScaler
extends Transformer
implements HasNumberOfFeatures {
    public StandardScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape;
        Boolean withMean = this.getWithMean();
        Boolean withStd = this.getWithStd();
        if (withMean.booleanValue()) {
            shape = this.getMeanShape();
        } else if (withStd.booleanValue()) {
            shape = this.getStdShape();
        } else {
            return -1;
        }
        return shape[0];
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> std;
        Boolean withMean = this.getWithMean();
        Boolean withStd = this.getWithStd();
        List<? extends Number> mean = withMean != false ? this.getMean() : null;
        List<? extends Number> list = std = withStd != false ? this.getStd() : null;
        if (mean == null && std == null) {
            return features;
        }
        ClassDictUtil.checkSize(features, mean, std);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Double stdValue;
            Feature feature = features.get(i);
            Double meanValue = withMean != false ? (Number)mean.get(i) : (Number)0.0;
            Number number = stdValue = withStd != false ? (Number)std.get(i) : (Number)1.0;
            if (ValueUtil.isZero((Number)meanValue) && ValueUtil.isOne((Number)stdValue)) {
                result.add(feature);
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            FieldRef expression = continuousFeature.ref();
            if (!ValueUtil.isZero((Number)meanValue)) {
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)meanValue)});
            }
            if (!ValueUtil.isOne((Number)stdValue)) {
                expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)stdValue)});
            }
            DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"standard_scaler", (Feature)continuousFeature), (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public Boolean getWithMean() {
        return this.getBoolean("with_mean");
    }

    public Boolean getWithStd() {
        return this.getBoolean("with_std");
    }

    public List<? extends Number> getMean() {
        return this.getArray("mean_", Number.class);
    }

    public int[] getMeanShape() {
        return this.getArrayShape("mean_", 1);
    }

    public List<? extends Number> getStd() {
        if (this.containsKey("std_")) {
            return this.getArray("std_", Number.class);
        }
        return this.getArray("scale_", Number.class);
    }

    public int[] getStdShape() {
        if (this.containsKey("std_")) {
            return this.getArrayShape("std_", 1);
        }
        return this.getArrayShape("scale_", 1);
    }
}

