/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import java.util.List;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.jpmml.converter.CMatrix;
import org.jpmml.converter.Matrix;
import org.jpmml.converter.Schema;
import org.jpmml.converter.support_vector_machine.LibSVMUtil;
import sklearn.Classifier;
import sklearn.svm.SupportVectorMachineUtil;

public class LibSVMClassifier
extends Classifier {
    public LibSVMClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getSupportVectorsShape();
        return shape[1];
    }

    @Override
    public boolean hasProbabilityDistribution() {
        return false;
    }

    public SupportVectorMachineModel encodeModel(Schema schema) {
        int[] shape = this.getSupportVectorsShape();
        int numberOfVectors = shape[0];
        int numberOfFeatures = shape[1];
        List<Integer> support = this.getSupport();
        List<? extends Number> supportVectors = this.getSupportVectors();
        List<Integer> supportSizes = this.getSupportSizes();
        List<? extends Number> dualCoef = this.getDualCoef();
        List<? extends Number> intercept = this.getIntercept();
        Kernel kernel = SupportVectorMachineUtil.createKernel(this.getKernel(), this.getDegree(), this.getGamma(), this.getCoef0());
        SupportVectorMachineModel supportVectorMachineModel = LibSVMUtil.createClassification((Kernel)kernel, (Matrix)new CMatrix(supportVectors, numberOfVectors, numberOfFeatures), supportSizes, SupportVectorMachineUtil.formatIds(support), intercept, dualCoef, (Schema)schema);
        List supportVectorMachines = supportVectorMachineModel.getSupportVectorMachines();
        for (SupportVectorMachine supportVectorMachine : supportVectorMachines) {
            Object category = supportVectorMachine.getTargetCategory();
            Object alternateTargetCategory = supportVectorMachine.getAlternateTargetCategory();
            supportVectorMachine.setTargetCategory(alternateTargetCategory);
            supportVectorMachine.setAlternateTargetCategory(category);
        }
        return supportVectorMachineModel;
    }

    public String getKernel() {
        return this.getString("kernel");
    }

    public Integer getDegree() {
        return this.getInteger("degree");
    }

    public Number getGamma() {
        return this.getNumber("_gamma");
    }

    public Number getCoef0() {
        return this.getNumber("coef0");
    }

    public List<Integer> getSupport() {
        return this.getIntegerArray("support_");
    }

    public List<? extends Number> getSupportVectors() {
        return this.getArray("support_vectors_", Number.class);
    }

    public int[] getSupportVectorsShape() {
        return this.getArrayShape("support_vectors_", 2);
    }

    public List<Integer> getSupportSizes() {
        return this.getIntegerArray("n_support_");
    }

    public List<? extends Number> getDualCoef() {
        return this.getArray("_dual_coef_", Number.class);
    }

    public List<? extends Number> getIntercept() {
        return this.getArray("_intercept_", Number.class);
    }
}

