/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Counts;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Value;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn2pmml.decoration.DomainUtil;

public abstract class Domain
extends Transformer {
    public Domain(String module, String name) {
        super(module, name);
    }

    @Override
    public DataField updateDataField(DataField dataField, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        FieldName name = dataField.getName();
        if (encoder.isFrozen(name)) {
            throw new IllegalArgumentException("Field " + name.getValue() + " is frozen for type information updates");
        }
        dataField.setDataType(dataType).setOpType(opType);
        encoder.setFrozen(name, this);
        return dataField;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        MissingValueTreatmentMethod missingValueTreatment = DomainUtil.parseMissingValueTreatment(this.getMissingValueTreatment());
        Object missingValueReplacement = this.getMissingValueReplacement();
        List<Object> missingValues = this.getMissingValues();
        if (missingValueReplacement != null && missingValueTreatment == null) {
            missingValueTreatment = MissingValueTreatmentMethod.AS_VALUE;
        }
        InvalidValueTreatmentMethod invalidValueTreatment = DomainUtil.parseInvalidValueTreatment(this.getInvalidValueTreatment());
        Object invalidValueReplacement = this.getInvalidValueReplacement();
        if (invalidValueReplacement != null && invalidValueTreatment == null) {
            invalidValueTreatment = InvalidValueTreatmentMethod.AS_IS;
        }
        for (Feature feature : features) {
            DataField dataField = (DataField)feature.getField();
            if (missingValueTreatment != null) {
                encoder.addDecorator(dataField, (Decorator)new MissingValueDecorator(missingValueTreatment, missingValueReplacement));
            }
            if (missingValues != null) {
                PMMLUtil.addValues((Field)dataField, missingValues, (Value.Property)Value.Property.MISSING);
            }
            if (invalidValueTreatment == null) continue;
            encoder.addDecorator(dataField, (Decorator)new InvalidValueDecorator(invalidValueTreatment, invalidValueReplacement));
        }
        return features;
    }

    public Object getDType() {
        if (!this.containsKey("dtype")) {
            return null;
        }
        return super.getDType(true);
    }

    public String getMissingValueTreatment() {
        return this.getOptionalString("missing_value_treatment");
    }

    public Object getMissingValueReplacement() {
        return this.getOptionalScalar("missing_value_replacement");
    }

    public List<Object> getMissingValues() {
        Object missingValues = this.getOptionalObject("missing_values");
        if (missingValues != null) {
            if (!(missingValues instanceof List)) {
                return Collections.singletonList(missingValues);
            }
            return (List)missingValues;
        }
        return null;
    }

    public String getInvalidValueTreatment() {
        return this.getOptionalString("invalid_value_treatment");
    }

    public Object getInvalidValueReplacement() {
        return this.getOptionalScalar("invalid_value_replacement");
    }

    public Boolean getWithData() {
        return this.getOptionalBoolean("with_data", Boolean.TRUE);
    }

    public Boolean getWithStatistics() {
        return this.getOptionalBoolean("with_statistics", Boolean.FALSE);
    }

    public Map<String, ?> getCounts() {
        return this.get("counts_", Map.class);
    }

    public static Counts createCounts(Map<String, ?> values) {
        Counts counts = new Counts().setTotalFreq(Domain.selectValue(values, "totalFreq", 0)).setMissingFreq(Domain.selectValue(values, "missingFreq")).setInvalidFreq(Domain.selectValue(values, "invalidFreq"));
        return counts;
    }

    protected static Map<String, ?> extractMap(Map<String, ?> map, int index) {
        LinkedHashMap result = new LinkedHashMap();
        Set<Map.Entry<String, ?>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            List<?> value = Domain.asArray(entry.getValue());
            result.put(key, value.get(index));
        }
        return result;
    }

    protected static Number selectValue(Map<String, ?> values, String key) {
        return Domain.selectValue(values, key, null);
    }

    protected static Number selectValue(Map<String, ?> values, String key, Number defaultValue) {
        Number value = (Number)values.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected static WildcardFeature asWildcardFeature(Feature feature) {
        if (feature instanceof WildcardFeature) {
            WildcardFeature wildcardFeature = (WildcardFeature)feature;
            return wildcardFeature;
        }
        throw new IllegalArgumentException("Field " + feature.getName() + " is not decorable");
    }

    protected static List<?> asArray(Object object) {
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayContent();
        }
        if (object instanceof Number) {
            return Collections.singletonList(object);
        }
        throw new IllegalArgumentException(ClassDictUtil.formatClass(object) + " is not a supported array type");
    }
}

