/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.ensemble;

import com.google.common.collect.Iterables;
import java.util.List;
import org.dmg.pmml.Model;
import org.jpmml.converter.Schema;
import sklearn.Regressor;
import sklearn.linear_model.LinearRegressor;
import sklearn.preprocessing.MultiOneHotEncoder;
import sklearn2pmml.ensemble.GBDTUtil;

public class GBDTLMRegressor
extends Regressor {
    public GBDTLMRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public Model encodeModel(Schema schema) {
        Regressor gbdt = this.getGBDT();
        MultiOneHotEncoder ohe = this.getOHE();
        LinearRegressor lm = this.getLM();
        List<? extends Number> coef = lm.getCoef();
        List<? extends Number> intercept = lm.getIntercept();
        return GBDTUtil.encodeModel(gbdt, ohe, coef, (Number)Iterables.getOnlyElement(intercept), schema);
    }

    public Regressor getGBDT() {
        return this.get("gbdt_", Regressor.class);
    }

    public LinearRegressor getLM() {
        return this.get("lm_", LinearRegressor.class);
    }

    public MultiOneHotEncoder getOHE() {
        return this.get("ohe_", MultiOneHotEncoder.class);
    }
}

