/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.ensemble;

import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.PredicateTranslator;
import org.jpmml.sklearn.TupleUtil;
import sklearn.ClassifierUtil;
import sklearn.Estimator;
import sklearn.HasClasses;

public class SelectFirstEstimator
extends Estimator
implements HasClasses {
    public SelectFirstEstimator(String module, String name) {
        super(module, name);
    }

    @Override
    public MiningFunction getMiningFunction() {
        Estimator estimator = this.getEstimator();
        return estimator.getMiningFunction();
    }

    @Override
    public List<?> getClasses() {
        Estimator estimator = this.getEstimator();
        return ClassifierUtil.getClasses(estimator);
    }

    @Override
    public Model encodeModel(Schema schema) {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            throw new IllegalArgumentException();
        }
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        MiningFunction miningFunction = null;
        Segmentation segmentation = new Segmentation(Segmentation.MultipleModelMethod.SELECT_FIRST, null);
        for (Object[] step : steps) {
            String predicate = TupleUtil.extractElement(step, 0, String.class);
            Estimator estimator = TupleUtil.extractElement(step, 1, Estimator.class);
            if (miningFunction == null) {
                miningFunction = estimator.getMiningFunction();
            } else if (!miningFunction.equals((Object)estimator.getMiningFunction())) {
                throw new IllegalArgumentException();
            }
            Predicate pmmlPredicate = PredicateTranslator.translate(predicate, features);
            Model model = estimator.encodeModel(schema);
            Segment segment = new Segment(pmmlPredicate, model);
            segmentation.addSegments(new Segment[]{segment});
        }
        MiningModel miningModel = new MiningModel(miningFunction, ModelUtil.createMiningSchema((Label)label)).setSegmentation(segmentation);
        return miningModel;
    }

    public Estimator getEstimator() {
        List<Object[]> steps = this.getSteps();
        if (steps.size() < 1) {
            throw new IllegalArgumentException();
        }
        Object[] step = steps.get(0);
        return TupleUtil.extractElement(step, 1, Estimator.class);
    }

    public List<Object[]> getSteps() {
        return this.getTupleList("steps");
    }
}

