/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import com.google.common.base.CaseFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public abstract class DurationTransformer
extends Transformer {
    public DurationTransformer(String module, String name) {
        super(module, name);
    }

    public abstract String getFunction();

    @Override
    public DataType getDataType() {
        return DataType.INTEGER;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        LocalDateTime epochDateTime;
        GregorianCalendar epoch = this.getEpoch();
        String function = this.getFunction();
        ZoneId epochZoneId = ZoneId.systemDefault();
        TimeZone epochTimeZone = epoch.getTimeZone();
        if (epochTimeZone != null) {
            epochZoneId = epochTimeZone.toZoneId();
        }
        if ((epochDateTime = LocalDateTime.ofInstant(epoch.toInstant(), epochZoneId)).getMonthValue() != 1 || epochDateTime.getDayOfMonth() != 1) {
            throw new IllegalArgumentException(String.valueOf(epochDateTime));
        }
        int year = epochDateTime.getYear();
        String dateFunction = function;
        if (dateFunction.startsWith("date")) {
            dateFunction = dateFunction.substring("date".length(), dateFunction.length());
        }
        dateFunction = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, dateFunction);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            ObjectFeature objectFeature = (ObjectFeature)features.get(i);
            FieldName name = FieldName.create((String)(dateFunction + "(" + FeatureUtil.getName((Feature)objectFeature).getValue() + ", " + year + ")"));
            DerivedField derivedField = encoder.ensureDerivedField(name, OpType.CONTINUOUS, DataType.INTEGER, () -> PMMLUtil.createApply((String)function, (Expression[])new Expression[]{objectFeature.ref(), PMMLUtil.createConstant((Object)year, (DataType)DataType.INTEGER)}));
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public GregorianCalendar getEpoch() {
        return this.get("epoch", GregorianCalendar.class);
    }
}

