/*
 * Decompiled with CFR 0.152.
 */
package sklearn_pandas;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.CastFunction;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Initializer;
import sklearn.Transformer;
import sklearn_pandas.TransformerPipeline;

public class DataFrameMapper
extends Initializer {
    public DataFrameMapper(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> initializeFeatures(SkLearnEncoder encoder) {
        Object _default = this.getDefault();
        List<Object[]> rows = this.getFeatures();
        if (!Boolean.FALSE.equals(_default)) {
            throw new IllegalArgumentException("Attribute '" + ClassDictUtil.formatMember(this, "default") + "' must be set to the 'False' value");
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Object[] row : rows) {
            Map map;
            String alias;
            List<Feature> rowFeatures = new ArrayList<Feature>();
            List<String> columns = DataFrameMapper.getColumnList(row);
            for (String string : columns) {
                FieldName name = FieldName.create((String)string);
                DataField dataField = encoder.getDataField(name);
                if (dataField == null) {
                    dataField = encoder.createDataField(name);
                }
                rowFeatures.add((Feature)new WildcardFeature((PMMLEncoder)encoder, dataField));
            }
            List<Transformer> transformers = DataFrameMapper.getTransformerList(row);
            for (Transformer transformer : transformers) {
                rowFeatures = transformer.updateAndEncodeFeatures(rowFeatures, encoder);
            }
            if (row.length > 2 && (alias = (String)(map = (Map)row[2]).get("alias")) != null) {
                for (int i = 0; i < rowFeatures.size(); ++i) {
                    Feature rowFeature = rowFeatures.get(i);
                    encoder.renameFeature(rowFeature, rowFeatures.size() > 1 ? FieldName.create((String)(alias + "_" + i)) : FieldName.create((String)alias));
                }
            }
            result.addAll(rowFeatures);
        }
        return result;
    }

    public Object getDefault() {
        return this.getObject("default");
    }

    public DataFrameMapper setDefault(Object _default) {
        this.put("default", _default);
        return this;
    }

    public List<Object[]> getFeatures() {
        return this.getTupleList("features");
    }

    public DataFrameMapper setFeatures(List<Object[]> features) {
        this.put("features", features);
        return this;
    }

    private static List<String> getColumnList(Object[] feature) {
        List<?> key = feature[0];
        if (key instanceof HasArray) {
            HasArray hasArray = (HasArray)((Object)key);
            key = hasArray.getArrayContent();
        }
        CastFunction<String> castFunction = new CastFunction<String>(String.class){

            @Override
            protected String formatMessage(Object object) {
                return "The key object (" + ClassDictUtil.formatClass(object) + ") is not a String";
            }
        };
        if (key instanceof List) {
            return Lists.transform(key, (Function)castFunction);
        }
        return Collections.singletonList(castFunction.apply(key));
    }

    private static List<Transformer> getTransformerList(Object[] feature) {
        List<?> value = feature[1];
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof TransformerPipeline) {
            TransformerPipeline transformerPipeline = (TransformerPipeline)((Object)value);
            List<Object[]> steps = transformerPipeline.getSteps();
            value = TupleUtil.extractElementList(steps, 1);
        }
        CastFunction<Transformer> castFunction = new CastFunction<Transformer>(Transformer.class){

            @Override
            protected String formatMessage(Object object) {
                return "The value object (" + ClassDictUtil.formatClass(object) + ") is not a supported Transformer";
            }
        };
        if (value instanceof List) {
            return Lists.transform(value, (Function)castFunction);
        }
        return Collections.singletonList(castFunction.apply(value));
    }
}

