/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import sklearn.Classifier;
import sklearn.neighbors.HasNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsUtil;

public class KNeighborsClassifier
extends Classifier
implements HasNeighbors,
HasTrainingData {
    public KNeighborsClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFitXShape();
        return shape[1];
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public NearestNeighborModel encodeModel(Schema schema) {
        int[] shape = this.getFitXShape();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        NearestNeighborModel nearestNeighborModel = KNeighborsUtil.encodeNeighbors(this, MiningFunction.CLASSIFICATION, numberOfInstances, numberOfFeatures, schema).setCategoricalScoringMethod(NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE);
        return nearestNeighborModel;
    }

    @Override
    public String getMetric() {
        return (String)this.get("metric");
    }

    @Override
    public int getNumberOfNeighbors() {
        return KNeighborsUtil.getNumberOfNeighbors(this);
    }

    @Override
    public int getP() {
        return ValueUtil.asInt((Number)((Number)this.get("p")));
    }

    @Override
    public String getWeights() {
        return (String)this.get("weights");
    }

    @Override
    public List<? extends Number> getFitX() {
        return this.getArray("_fit_X", Number.class);
    }

    public int[] getFitXShape() {
        return this.getArrayShape("_fit_X", 2);
    }

    @Override
    public List<?> getY() {
        List<Number> y = this.getArray("_y", Number.class);
        Function<Number, Object> function = new Function<Number, Object>(){
            private List<?> classes;
            {
                this.classes = KNeighborsClassifier.this.getClasses();
            }

            public Object apply(Number number) {
                int index = ValueUtil.asInt((Number)number);
                return this.classes.get(index);
            }
        };
        return Lists.transform(y, (Function)function);
    }
}

