/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;

public class MinMaxScaler
extends Transformer
implements HasNumberOfFeatures {
    public MinMaxScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getScaleShape();
        return shape[0];
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> min = this.getMin();
        List<? extends Number> scale = this.getScale();
        ClassDictUtil.checkSize(features, min, scale);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Number minValue = min.get(i);
            Number scaleValue = scale.get(i);
            if (ValueUtil.isOne((Number)scaleValue) && ValueUtil.isZero((Number)minValue)) {
                result.add(feature);
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            FieldRef expression = continuousFeature.ref();
            if (!ValueUtil.isOne((Number)scaleValue)) {
                expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)scaleValue)});
            }
            if (!ValueUtil.isZero((Number)minValue)) {
                expression = PMMLUtil.createApply((String)"+", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)minValue)});
            }
            DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"mix_max_scaler", (Feature)continuousFeature), (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public List<? extends Number> getMin() {
        return this.getArray("min_", Number.class);
    }

    public List<? extends Number> getScale() {
        return this.getArray("scale_", Number.class);
    }

    public int[] getScaleShape() {
        return this.getArrayShape("scale_", 1);
    }
}

