/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;

public class Aggregator
extends Transformer
implements HasNumberOfFeatures {
    public Aggregator(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        return -1;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        String function = this.getFunction();
        if (features.size() <= 1) {
            return features;
        }
        Apply apply = new Apply(Aggregator.translateFunction(function));
        for (Feature feature : features) {
            apply.addExpressions(new Expression[]{feature.ref()});
        }
        FieldName name = FeatureUtil.createName((String)function, features);
        DerivedField derivedField = encoder.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
        return Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    public String getFunction() {
        return (String)this.get("function");
    }

    private static String translateFunction(String function) {
        switch (function) {
            case "min": 
            case "max": {
                return function;
            }
            case "mean": {
                return "avg";
            }
        }
        throw new IllegalArgumentException(function);
    }
}

