/*
 * Decompiled with CFR 0.152.
 */
package tpot.builtins;

import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.PMMLEncoder;
import tpot.builtins.OutputUtil;

public class ContinuousOutputFeature
extends ContinuousFeature {
    private Output output = null;

    public ContinuousOutputFeature(PMMLEncoder encocder, Output output, OutputField outputField) {
        this(encocder, output, outputField.getName(), outputField.getDataType());
    }

    public ContinuousOutputFeature(PMMLEncoder encoder, Output output, FieldName name, DataType dataType) {
        super(encoder, name, dataType);
        this.setOutput(output);
    }

    public ContinuousOutputFeature toContinuousFeature() {
        return this;
    }

    public ContinuousOutputFeature toContinuousFeature(DataType dataType) {
        ContinuousOutputFeature continuousFeature = this.toContinuousFeature();
        if (dataType.equals((Object)continuousFeature.getDataType())) {
            return continuousFeature;
        }
        PMMLEncoder encoder = this.ensureEncoder();
        FieldName name = FieldName.create((String)(dataType.name().toLowerCase() + "(" + continuousFeature.getName().getValue() + ")"));
        Output output = this.getOutput();
        OutputField outputField = OutputUtil.getOutputField(output, name);
        if (outputField == null) {
            outputField = new OutputField(name, dataType).setOpType(OpType.CONTINUOUS).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setFinalResult(Boolean.valueOf(false)).setExpression((Expression)continuousFeature.ref());
            output.addOutputFields(new OutputField[]{outputField});
        }
        return new ContinuousOutputFeature(encoder, output, outputField);
    }

    public Output getOutput() {
        return this.output;
    }

    private void setOutput(Output output) {
        if (output == null) {
            throw new IllegalArgumentException();
        }
        this.output = output;
    }
}

