/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn.visitors;

import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.visitors.AbstractVisitor;

public class TreeModelFlattener
extends AbstractVisitor {
    private MiningFunction miningFunction = null;

    public void pushParent(PMMLObject object) {
        super.pushParent(object);
        if (object instanceof TreeModel) {
            this.handleTreeModelPush((TreeModel)object);
        }
    }

    public PMMLObject popParent() {
        PMMLObject object = super.popParent();
        if (object instanceof Node) {
            this.handleNodePop((Node)object);
        } else if (object instanceof TreeModel) {
            this.handleTreeModelPop((TreeModel)object);
        }
        return object;
    }

    public VisitorAction visit(Node node) {
        if (node.hasNodes()) {
            List children = node.getNodes();
            block0: while (true) {
                ListIterator<Node> childIt = children.listIterator();
                while (childIt.hasNext()) {
                    Node child = (Node)childIt.next();
                    Iterator<Node> grandChildIt = TreeModelFlattener.getChildren(child);
                    if (grandChildIt == null) continue;
                    childIt.remove();
                    while (grandChildIt.hasNext()) {
                        Node grandChild = grandChildIt.next();
                        grandChildIt.remove();
                        childIt.add(grandChild);
                    }
                    childIt.add(child);
                    continue block0;
                }
                break;
            }
        }
        return super.visit(node);
    }

    public VisitorAction visit(TreeModel treeModel) {
        treeModel.setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        return super.visit(treeModel);
    }

    private void handleNodePop(Node node) {
        String score = node.getScore();
        Predicate predicate = node.getPredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            List parentChildren = parentNode.getNodes();
            if (parentChildren.size() != 1) {
                return;
            }
            boolean success = parentChildren.remove(node);
            if (!success) {
                throw new IllegalArgumentException();
            }
            String parentScore = parentNode.getScore();
            if (parentScore != null) {
                throw new IllegalArgumentException();
            }
            parentNode.setScore(score);
            if (!MiningFunction.REGRESSION.equals((Object)this.miningFunction)) {
                if (MiningFunction.CLASSIFICATION.equals((Object)this.miningFunction)) {
                    Double recordCount = node.getRecordCount();
                    List scoreDistributions = node.getScoreDistributions();
                    Double parentRecordCount = parentNode.getRecordCount();
                    if (parentRecordCount != null) {
                        throw new IllegalArgumentException();
                    }
                    parentNode.setRecordCount(recordCount);
                    List parentScoreDistributions = parentNode.getScoreDistributions();
                    if (parentScoreDistributions.size() != 0) {
                        throw new IllegalArgumentException();
                    }
                    parentScoreDistributions.addAll(scoreDistributions);
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private void handleTreeModelPush(TreeModel treeModel) {
        this.miningFunction = treeModel.getMiningFunction();
    }

    private void handleTreeModelPop(TreeModel treeModel) {
        this.miningFunction = null;
    }

    private Node getParentNode() {
        Deque parents = this.getParents();
        PMMLObject parent = (PMMLObject)parents.peekFirst();
        if (parent instanceof Node) {
            return (Node)parent;
        }
        return null;
    }

    private static Iterator<Node> getChildren(Node node) {
        Predicate predicate = node.getPredicate();
        if (!(predicate instanceof SimplePredicate)) {
            return null;
        }
        SimplePredicate simplePredicate = (SimplePredicate)predicate;
        FieldName name = simplePredicate.getField();
        SimplePredicate.Operator operator = simplePredicate.getOperator();
        if (!SimplePredicate.Operator.LESS_OR_EQUAL.equals((Object)operator)) {
            return null;
        }
        if (node.hasNodes()) {
            Node child;
            List children = node.getNodes();
            int endPos = 0;
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && TreeModelFlattener.checkPredicate(child = (Node)iterator.next(), name, operator)) {
                ++endPos;
            }
            if (endPos > 0) {
                return children.subList(0, endPos).iterator();
            }
            return null;
        }
        return null;
    }

    private static boolean checkPredicate(Node node, FieldName name, SimplePredicate.Operator operator) {
        Predicate predicate = node.getPredicate();
        if (predicate instanceof SimplePredicate) {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            return simplePredicate.getField().equals((Object)name) && simplePredicate.getOperator().equals((Object)operator);
        }
        return false;
    }
}

